# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliGlobal
import ConfigMount
import ShowCommand
from CliPlugin.RouteMapCli import CommonTokens
from CliPlugin import RcfCliLib
from Toggles import RcfLibToggleLib

gv = CliGlobal.CliGlobal( dict(
   mapConfig=None, # Sysdb config path
   )
)

class RcfRouteMapCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'route-map [ MAP ] convert rcf'
   data = {
         'route-map': 'route-map',
         'MAP': CommonTokens.routeMapName,
         'convert': 'Convert route map to',
         'rcf': RcfCliLib.rcfKw,
         }

   cliModel = 'RcfCliModels.RcfRouteMapConversionModel'
   handler = 'RcfRouteMapConversionHandler.handlerRcfRouteMapCmd'

if RcfLibToggleLib.toggleRcfRouteMapConverterEnabled():
   BasicCli.GlobalConfigMode.addCommandClass( RcfRouteMapCmd )

# -----------------------------------------------------------------------------------
# Plugin
# -----------------------------------------------------------------------------------
def Plugin( entityManager ):
   gv.mapConfig = ConfigMount.mount(
      entityManager, 'routing/routemap/config', 'Routing::RouteMap::Config', 'w' )
