# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#########################################################################
##  This is an extension to SysMgr's FileCli.
##  If the other supervisor is present and in active or standby mode,
##  then a PeerSupeFilesystem for the other supervisor should be registered.
##  When a PeerSupeFilesystem is registered, the FileCli commands can
##  access the other supervisor's filesystem.
#########################################################################

import Tac, Cell, Url
import CliPlugin.FruCli as FruCli # pylint: disable=consider-using-from-import
import UrlPlugin.SupeUrl as SupeUrl # pylint: disable=consider-using-from-import
import LazyMount

redundancyStatusReactor_ = None
entityManager_ = None
redundancyStatus_ = None

class RedundancyStatusReactor( Tac.Notifiee ):
   notifierTypeName = "Redundancy::RedundancyStatus"

   def __init__( self, redundancyStatus ):
      Tac.Notifiee.__init__( self, redundancyStatus )
      self.handlePeerRedundancyMode()

   @Tac.handler( "peerMode" )
   def handlePeerRedundancyMode( self ):
      peerSupScheme = "supervisor-peer:"
      peerMode = self.notifier_.peerMode
      peerFs = Url.getFilesystem( peerSupScheme )
      if peerMode != 'standby':
         if peerFs:
            Url.unregisterFilesystem( peerFs )
      else:
         if not peerFs:
            Url.registerFilesystem(
               SupeUrl.PeerSupeFilesystem( peerSupScheme, "/" ) )

def _createRedundancyStatusReactor():
   global redundancyStatusReactor_
   redundancyStatusReactor_ = RedundancyStatusReactor( redundancyStatus_.force() )

FruCli.registerModularSystemCallback( _createRedundancyStatusReactor )

def Plugin( entityManager ):
   global entityManager_
   global redundancyStatus_

   entityManager_ = entityManager
   # For supervisors cellId == slotId
   # Generally slotId is used when supervisor is a piece of hardware as in
   # "show module" cli and cellId is used when software running on it is emphasized
   # as in supervisor specific Tac entities like Election::Status.
   redundancyStatus_ = LazyMount.mount( entityManager,
                                        Cell.path( 'redundancy/status' ),
                                        'Redundancy::RedundancyStatus', 'r' )
