#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
from CliMatcher import KeywordMatcher, IntegerMatcher
import CliPlugin.RedSupCli as RedSupCli # pylint: disable=consider-using-from-import
from CliPlugin.RedSupCli import ssoSupportedGuard
from CliPlugin.ReloadCli import modularActiveSupeGuard

#--------------------------------------------------------------------------------
# [ no | default ] protocol ( simplex | rpr | sso )
#--------------------------------------------------------------------------------
class ProtocolCmd( CliCommand.CliCommandClass ):
   syntax = 'protocol ( simplex | rpr | sso )'
   noOrDefaultSyntax = 'protocol ...'
   data = {
      'protocol': CliCommand.Node( matcher=KeywordMatcher( 'protocol',
         helpdesc='Configure the redundancy protocol' ),
         guard=modularActiveSupeGuard ),
      'simplex': 'Disable redundancy',
      'rpr': 'Route processor redundancy protocol',
      'sso': CliCommand.Node( matcher=KeywordMatcher( 'sso',
         helpdesc='Stateful switchover redundancy protocol' ),
         guard=ssoSupportedGuard ),
   }
   handler = RedSupCli.setRedundancyProtocol
   noOrDefaultHandler = RedSupCli.setRedundancyProtocol

RedSupCli.RedundancyMode.addCommandClass( ProtocolCmd )

#--------------------------------------------------------------------------------
# [ no | default ] switchover completion timeout TIMEOUT
#--------------------------------------------------------------------------------
class SwitchoverCompletionTimeoutCmd( CliCommand.CliCommandClass ):
   syntax = 'switchover completion timeout TIMEOUT'
   noOrDefaultSyntax = 'switchover completion timeout ...'
   data = {
      'switchover': CliCommand.Node( matcher=KeywordMatcher( 'switchover',
         helpdesc='Stateful switchover information' ),
         guard=ssoSupportedGuard ),
      'completion': 'Configure switchover completion',
      'timeout': 'Configure timeout',
      'TIMEOUT': IntegerMatcher( 120, 1000,
         helpdesc='Switchover timeout in seconds' ),
   }
   handler = RedSupCli.setStageCompletionTimeout
   noHandler = RedSupCli.noStageCompletionTimeout
   defaultHandler = RedSupCli.defaultStageCompletionTimeout

RedSupCli.RedundancyMode.addCommandClass( SwitchoverCompletionTimeoutCmd )

#--------------------------------------------------------------------------------
# [ no | default ] file replication
#--------------------------------------------------------------------------------
class GotoFileReplicationMode( CliCommand.CliCommandClass ):
   syntax = 'file replication'
   noOrDefaultSyntax = syntax
   data = {
      'file' : 'Configure file related settings',
      'replication' : 'Configure file replication'
      }
   handler = RedSupCli.gotoFileReplicationMode
   noOrDefaultHandler = RedSupCli.noFileReplicationMode

RedSupCli.RedundancyMode.addCommandClass( GotoFileReplicationMode )
