#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliMatcher
import ShowCommand
# pylint: disable-next=consider-using-from-import
import CliPlugin.ReloadCauseCli as ReloadCauseCli
# pylint: disable-next=consider-using-from-import
import CliPlugin.ReloadCauseHistoryCli as ReloadCauseHistoryCli

matcherCause = CliMatcher.KeywordMatcher( 'cause',
      helpdesc='Display up to last 2000 lines of previous system reload cause' )
matcherReload = CliMatcher.KeywordMatcher( 'reload',
      helpdesc='Display system reload status' )

#--------------------------------------------------------------------------------
# show reload cause [ full ]
#--------------------------------------------------------------------------------
class ReloadCauseCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show reload cause [ full ]'
   data = {
      'reload': matcherReload,
      'cause': matcherCause,
      'full': 'Display full debug info',
   }
   handler = ReloadCauseCli.doShowReloadCause
   cliModel = ReloadCauseCli.ReloadCauses

BasicCli.addShowCommandClass( ReloadCauseCmd )

#--------------------------------------------------------------------------------
# show reload cause history
#--------------------------------------------------------------------------------
class ReloadCauseHistoryCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show reload cause history'
   data = {
      'reload': matcherReload,
      'cause': matcherCause,
      'history': 'Display reload causes for up to last 10 reboots',
   }
   handler = ReloadCauseHistoryCli.doShowReloadCauseHistory
   cliModel = ReloadCauseHistoryCli.ReloadCausesHistory

BasicCli.addShowCommandClass( ReloadCauseHistoryCmd )
