# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliCommand
import CliMatcher
import CliParser
import LazyMount

routingHwStatusCommon = None
routingHwStatus = None
routingHwRouteStatus = None

# Guard to disable the CLI on unsupported platforms
def routeCacheSupported( mode, token ):
   rhs = routingHwStatus
   if rhs is None:
      rhs = mode.sysdbRoot[ 'routing' ][ 'hardware' ][ 'status' ]

   if rhs.routeCacheSupported or rhs.staticVxlanRouteRibBypassSupported:
      return None
   else:
      return CliParser.guardNotThisPlatform

# Guard to disable the CLI on unsupported platforms
def routeCacheOnlySupported( mode, token ):
   rhs = routingHwStatus
   if rhs is None:
      rhs = mode.sysdbRoot[ 'routing' ][ 'hardware' ][ 'status' ]

   if rhs.routeCacheSupported:
      return None
   else:
      return CliParser.guardNotThisPlatform

routeCacheKw = CliCommand.guardedKeyword( 'route-cache',
                                           helpdesc='Route cache feature',
                                           guard=routeCacheSupported )

cacheKw = CliCommand.guardedKeyword( 'cache',
                                      helpdesc='Route cache information',
                                      guard=routeCacheSupported )

thresholdKw = CliCommand.guardedKeyword( 'threshold',
                    helpdesc='Display parameters for different threshold levels',
                    guard=routeCacheOnlySupported )

hitbitKw = CliMatcher.KeywordMatcher( 'hitbit', helpdesc='Hitbit information' )

def Plugin( entityManager ):
   global routingHwStatusCommon, routingHwStatus, routingHwRouteStatus
   routingHwStatusCommon = LazyMount.mount(
         entityManager,
         'routing/hardware/statuscommon',
         'Routing::Hardware::StatusCommon',
         'r' )
   routingHwStatus = LazyMount.mount(
         entityManager,
         'routing/hardware/status',
         'Routing::Hardware::Status',
         'r' )

   routingHwRouteStatus = LazyMount.mount(
         entityManager,
         'routing/hardware/route/status',
         'Routing::Hardware::RouteStatus',
         'r' )
