#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
from AgentCommandRequest import RunSocketCommandException, runSocketCommand
import CliModel
import AgentDirectory
import os
import Tracing

__defaultTraceHandle__ = Tracing.Handle( 'RouteCacheShowCliLib' )

def runAgentCommand( mode, command, model, **kwargs ):
   """
   @param mode: Cli Mode
   @param command: Command string to be send to agent
   @param model: Cli model used for Capi.
   @param **kwargs: Arbitrary keyword arguments, passed to runSocketCommand function

   @return: None when error occurs else model object having value set

   @exception: Handles RunSocketCommandException while other exception will be raised
   """
   # check if the agent is running
   if not isRouteCacheRunning( mode.entityManager.sysname() ):
      mode.addError( 'RouteCache agent is not running' )
      return None

   errors = [ 'RouteCache Agent is not initialized\n' ]
   try:
      outputFormat = mode.session_.outputFormat_
      runSocketCommand( mode.entityManager, "RouteCache", "RouteCacheWithFormat",
                     command,
                     outputFormat=outputFormat,
                     asyncCommand=True,
                     throwException=True, errors=errors, **kwargs )
      return CliModel.cliPrinted( model )
   except RunSocketCommandException as e:
      mode.addError( str( e ) )

def isRouteCacheRunning( sysname ):
   if 'AGENT_COMMAND_REQUEST_DRY_RUN' in os.environ:
      # Running from breadth tests
      return True

   return AgentDirectory.agent( sysname, 'RouteCache' ) != None
