# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import ConfigMount
import Tac
import Tracing

from CliToken import IpRibLibCliTokens

from CliPlugin.IpRibLib import ResolutionRibsExprFactory
from CliPlugin.RouterGeneralCli import (
   RouterGeneralVrfMode,
   matcherRoute,
   matcherStatic
)

traceHandle = Tracing.Handle( 'RouteStaticResRibs' )
t5 = traceHandle.trace5 # Info

config = None

def setNhResProfileConfig( mode, args ):
   t5( 'setting staticResRibProfileConfig' )
   vrfConfig = config.vrfConfig[ mode.vrfName ]
   name = 'IP_NON_COLOR_TUNNEL_ONLY_RIBS'
   newConfigStr = args[ name ].stringValue()
   currConfigStr = vrfConfig.staticResRibProfileConfig.stringValue()
   if newConfigStr != currConfigStr:
      vrfConfig.staticResRibProfileConfig = args[ name ]

def resetNhResProfileConfig( mode, args ):
   t5( 'no command, resetting staticResRibProfileConfig' )
   vrfConfig = config.vrfConfig[ mode.vrfName ]
   vrfConfig.staticResRibProfileConfig = Tac.Value(
         "Routing::Rib::ResolutionRibProfileConfig" )

class RouteStaticResRibsCmd( CliCommand.CliCommandClass ):
   syntax = 'route static next-hop resolution ribs IP_NON_COLOR_TUNNEL_ONLY_RIBS'
   noOrDefaultSyntax = 'route static next-hop resolution ribs ...'
   data = {
      'route' : matcherRoute,
      'static' : matcherStatic,
      'next-hop' : 'Next hop configuration',
      'resolution' : IpRibLibCliTokens.matcherResolution,
      'ribs' : 'Resolving RIBs in order of preference',
      'IP_NON_COLOR_TUNNEL_ONLY_RIBS' : ResolutionRibsExprFactory()
   }

   handler = setNhResProfileConfig
   noOrDefaultHandler = resetNhResProfileConfig

RouterGeneralVrfMode.addCommandClass( RouteStaticResRibsCmd )

def Plugin( entityManager ):
   global config

   config = ConfigMount.mount( entityManager, 'routing/general/config/global',
                               'Routing::General::Config', 'w' )

