#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from ShowCommand import ShowCliCommandClass
from CliMatcher import KeywordMatcher
from BasicCli import addShowCommandClass
from Toggles.RoutingLibToggleLib import toggleRouteVrfPrioritizationEnabled

kwRoute = KeywordMatcher( 'route', helpdesc='Route information' )
kwEvent = KeywordMatcher( 'event', helpdesc='Route event information' )
kwTrack = KeywordMatcher( 'track', helpdesc='Tracked route event information' )
kwDetail = KeywordMatcher( 'detail',
                           helpdesc='Display additional route event context' )

class ShowRouteTrackCommand( ShowCliCommandClass ):
   syntax = 'show route event track [detail]'
   data = {
      'route' : kwRoute,
      'event' : kwEvent,
      'track' : kwTrack,
      'detail' : kwDetail,
   }
   privileged = True
   hidden = True
   cliModel = 'RouteTrackModel.RouteTrackLog'
   handler = 'RouteTrackShowHandler.showRouteTrackCommandHandler'

if toggleRouteVrfPrioritizationEnabled():
   addShowCommandClass( ShowRouteTrackCommand )
