#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import ConfigMount
from CliPlugin import TechSupportCli
from CliPlugin.RoutingCommon import (
   GATED_PROTO_SH_TECH_TS,
   GATED_PROTO_FORK_SH_TECH_TS
)

bgpConfig = {}

def showRoutingBgpCliGuard():
   return bgpConfig.asNumber != 0

def showBgpSrTeTechGuard():
   srteActive = False
   for peer in bgpConfig.neighborConfig.values():
      neiConfig = bgpConfig.neighborConfig.get( peer.key )
      if neiConfig.afV4SrTe == 'afActive' or neiConfig.afV6SrTe == 'afActive':
         srteActive = True

   return srteActive
#-------------------------------------------------------------------------------
# BGP commands in 'show tech-support'
#-------------------------------------------------------------------------------
TechSupportCli.registerShowTechSupportCmd(
   GATED_PROTO_SH_TECH_TS,
   cmds=[ 'show bgp convergence vrf all',
          'show bgp statistics vrf all',
          'show bgp rcf',
          'show ip bgp vrf all',
          'show ipv6 bgp vrf all',
          'show ip bgp summary vrf all',
          'show ipv6 bgp summary vrf all',
          'show bgp summary vrf all',
          'show bgp neighbors vrf all' ],
   cmdsGuard=showRoutingBgpCliGuard )

TechSupportCli.registerShowTechSupportCmd(
   GATED_PROTO_FORK_SH_TECH_TS,
   cmds=[ 'show bgp sr-te summary vrf all',
          # Use 'detail' since that's the only version that prints the tunnel encap
          # attr info
          'show bgp sr-te detail vrf all' ],
   cmdsGuard=showBgpSrTeTechGuard )

TechSupportCli.registerShowTechSupportCmd(
   '2020-05-20 23:59:59',
   summaryCmds=[ 'show bgp statistics vrf all',
                 'show ip bgp summary vrf all',
                 'show ipv6 bgp summary vrf all' ] )

TechSupportCli.registerShowTechSupportCmd(
   '2020-05-20 23:59:59',
   summaryCmds=[ 'show bgp sr-te summary vrf all' ],
   cmdsGuard=showBgpSrTeTechGuard )

def Plugin( entityManager ):
   global bgpConfig
   bgpConfig = ConfigMount.mount(
                  entityManager,
                  'routing/bgp/config',
                  'Routing::Bgp::Config',
                  'w' )
