# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import IpAddrMatcher
from CliPlugin import Ip6AddrMatcher
from CliPlugin import RoutingIsisShowSegmentRoutingModel
from CliPlugin.RoutingIsisCli import (
   isisKw,
   isisInstanceMatcher,
   vrfKw,
   vrfNameMatcher,
   isisShowCommandSyntaxWrapper
)
from CliPlugin.TunnelCli import (
   tokenTunnelMatcher,
   tunnelIndexMatcher,
   readMountTunnelTable,
   TunnelTableIdentifier
)
import ShowCommand, CliMatcher, CliCommand, BasicCli

srTunnelTable = None

ipv4SegmentKw = CliMatcher.KeywordMatcher( 'ipv4',
                                           helpdesc='IS-IS SR IPv4 segments' )
ipv6SegmentKw = CliMatcher.KeywordMatcher( 'ipv6',
                                           helpdesc='IS-IS SR IPv6 segments' )
segmentRoutingKw = CliMatcher.KeywordMatcher( 'segment-routing',
                                             helpdesc='Segment routing information' )
selfOrigKw = CliMatcher.KeywordMatcher( 'self-originated',
                                        helpdesc='Self-Originated segments' )
sharedMatchObjectPfxSegment = object()

#------------------------------------------------------------------------------------
# The "show isis segment-routing adjacency-segments" command.
#------------------------------------------------------------------------------------

class ShowIsisSegmentRoutingCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'segment-routing' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'segment-routing' : segmentRoutingKw,
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = RoutingIsisShowSegmentRoutingModel.SegmentRoutingsSummaryVRFsModel
   handler = "RoutingIsisShowSegmentRoutingCli.ShowIsisSegmentRoutingCmdHandler"

BasicCli.addShowCommandClass( ShowIsisSegmentRoutingCmd )

class ShowIsisSegmentRoutingGlobalBlocksCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'segment-routing global-blocks' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'segment-routing' : segmentRoutingKw,
      'global-blocks' : 'Peer SRGBs',
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = RoutingIsisShowSegmentRoutingModel.\
              SegmentRoutingsGlobalBlocksSummaryVRFsModel
   handler = "RoutingIsisShowSegmentRoutingCli."\
             "ShowIsisSegmentRoutingGlobalBlocksCmdHandler"

BasicCli.addShowCommandClass( ShowIsisSegmentRoutingGlobalBlocksCmd )

class ShowIsisSegmentRoutingPrefixSegmentCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'segment-routing prefix-segments '
                                          '[ { [ self-originated ] '
                                          '[ ipv4 | ipv6 ] } ]' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'segment-routing' : segmentRoutingKw,
      'prefix-segments' : 'Prefix Segment Information',
      'ipv4' : CliCommand.Node( matcher=ipv4SegmentKw, maxMatches=1,
                                sharedMatchObj=sharedMatchObjectPfxSegment ),
      'ipv6' : CliCommand.Node( matcher=ipv6SegmentKw, maxMatches=1,
                                sharedMatchObj=sharedMatchObjectPfxSegment ),
      'self-originated' : CliCommand.Node( matcher=selfOrigKw, maxMatches=1 ),
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = RoutingIsisShowSegmentRoutingModel.\
              SegmentRoutingsPrefixSegmentsSummaryVRFsModel
   handler = "RoutingIsisShowSegmentRoutingCli."\
             "ShowIsisSegmentRoutingPrefixSegmentCmdHandler"

BasicCli.addShowCommandClass( ShowIsisSegmentRoutingPrefixSegmentCmd )

class ShowIsisSegmentRoutingAdjSegmentCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'segment-routing adjacency-segments' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'segment-routing' : segmentRoutingKw,
      'adjacency-segments' : 'Adjacency Segment Information',
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = RoutingIsisShowSegmentRoutingModel.\
              SegmentRoutingsAdjacencySegmentsSummaryVRFsModel
   handler = "RoutingIsisShowSegmentRoutingCli."\
             "ShowIsisSegmentRoutingAdjSegmentCmdHandler"

BasicCli.addShowCommandClass( ShowIsisSegmentRoutingAdjSegmentCmd )

#-------------------------------------------------------------------------------
# show isis segment-routing tunnel [ tunnel-index | tep ]
#-------------------------------------------------------------------------------

endpointHelpString = 'Match this endpoint prefix'

class ShowIsisSegmentRoutingTunnelCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show isis segment-routing tunnel ' \
            '[ IPADDR | IP6ADDR | TUNNEL-INDEX ]'
   data = {
      'isis' : isisKw,
      'segment-routing': segmentRoutingKw,
      'tunnel' : tokenTunnelMatcher,
      'IPADDR' : IpAddrMatcher.IpPrefixMatcher( helpdesc=endpointHelpString ),
      'IP6ADDR' : Ip6AddrMatcher.Ip6PrefixMatcher( helpdesc=endpointHelpString ),
      'TUNNEL-INDEX' : tunnelIndexMatcher,
   }
   cliModel = RoutingIsisShowSegmentRoutingModel.IsisSrTunnelTable
   handler = "RoutingIsisShowSegmentRoutingCli."\
             "ShowIsisSegmentRoutingTunnelCmdHandler"

BasicCli.addShowCommandClass( ShowIsisSegmentRoutingTunnelCmd )

def Plugin( entityManager ):
   global srTunnelTable

   srTunnelTable = readMountTunnelTable( TunnelTableIdentifier.srTunnelTable,
                                         entityManager )
