#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliPlugin.PolicyMapCliLib
from CliPlugin.TrafficPolicyCli import ActionCmdBase
from CliPlugin.TrafficPolicyCliLib import MatchRuleContext, PolicyConfigCmdBase
from CliPlugin.TrafficPolicyCliContext import TrafficPolicyBaseContext
import Tac

ActionType = Tac.Type( "PolicyMap::ActionType" )
UniqueId = Tac.Type( "Ark::UniqueId" )
CHANGED = CliPlugin.PolicyMapCliLib.CHANGED
IDENTICAL = CliPlugin.PolicyMapCliLib.IDENTICAL

class SamplePolicyContext( TrafficPolicyBaseContext ):
   pmapType = 'mapSamplePolicy'

   def childMode( self ):
      return NotImplementedError

   def copyAction( self, src ):
      actions = self.config().actions
      if src.actionType == ActionType.sample:
         return actions.sampleAction.newMember( src.className, UniqueId() )
      elif src.actionType == ActionType.sampleAll:
         return actions.sampleAllAction.newMember( src.className, UniqueId() )
      return None

   def removeAction( self, action ):
      actions = self.config().actions
      actType = action.actionType
      if actType == ActionType.sample:
         del actions.sampleAction[ action.id ]
      elif actType == ActionType.sampleAll:
         del actions.sampleAllAction[ action.id ]

   def identicalClassActions( self, c1Action, c2Action ):
      if super().identicalClassActions( c1Action, c2Action ) == CHANGED:
         return CHANGED
      # compare samples actions
      c1SampleValues = []
      c2SampleValues = []
      for k in c1Action.policyAction:
         if k == 'sample':
            c1SampleValues.append( 'sample' )
         elif k == 'sampleAll':
            c1SampleValues.append( 'sampleAll' )
      for k in c2Action.policyAction:
         if k == 'sample':
            c2SampleValues.append( 'sample' )
         elif k == 'sampleAll':
            c2SampleValues.append( 'sampleAll' )
      if sorted( c1SampleValues ) != sorted( c2SampleValues ):
         return CHANGED
      return IDENTICAL

class SamplePolicyMatchRuleContext( MatchRuleContext ):
   def childMode( self, matchRuleName, matchOption ):
      return NotImplementedError

   def actionMode( self ):
      return NotImplementedError

   def setAction( self, actionType, actionValue=None, no=False, clearActions=None ):
      if no:
         self.matchRuleAction.delAction( actionType )
      else:
         if clearActions:
            for action in clearActions:
               self.matchRuleAction.delAction( action )
         actionsConfig = self.trafficPolicyContext.config().actions
         if actionType == ActionType.sample:
            action = actionsConfig.sampleAction.newMember( self.ruleName,
                                                           UniqueId() )
         elif actionType == ActionType.sampleAll:
            action = actionsConfig.sampleAllAction.newMember( self.ruleName,
                                                              UniqueId() )
         else:
            assert False, 'unknown action ' + actionType
         self.matchRuleAction.addAction( actionType, action )

#[ no ] sample policy POLICY_NAME
class SamplePolicyConfigCmd( PolicyConfigCmdBase ):
   syntax = '''sample policy POLICY_NAME'''
   noOrDefaultSyntax = syntax
   _baseData = {
      'sample': 'Configure sampling feature',
      'policy': 'Configure sample policy',
   }

   @staticmethod
   def _feature():
      return NotImplementedError

   @classmethod
   def _context( cls, name, mode ):
      raise NotImplementedError

#------------------------------------------------------------------------------------
# The "sample [ all ]" action
#------------------------------------------------------------------------------------
class SampleActionCmd( ActionCmdBase ):
   syntax = 'sample [ all ]'
   noOrDefaultSyntax = syntax
   data = {
      'sample': 'Configure sample criteria',
      'all': 'Match all packets',
   }
   handler = "SamplePolicyCliLibHandlers.SampleActionCmdHandler"
   noOrDefaultHandler = \
         "SamplePolicyCliLibHandlers.SampleActionCmdNoOrDefaultHandler"

