#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import BasicCli
import CliCommand
import CliMatcher
from CliPlugin import AgentCli
from CliPlugin.SchanAccelCli import schanAccelEnabledGuard
from CliToken.Platform import platformMatcherForShow
import ShowCommand
import SharedMem
from Toggles.SchanAccelToggleLib import toggleSchanAccelCmdBatchTrackingEnabled
from TypeFuture import TacLazyType

MountConstants = TacLazyType( 'SchanAccel::CmdBatchMountConstants' )

def schanAccelAgentNames( mode ):
   allAgents = {}
   shmemEm = SharedMem.entityManager( MountConstants.sysName, False )
   for smashEntityPath in shmemEm.find( MountConstants.smashBasePath ).path:
      name = smashEntityPath.split( "/" )[ -1 ]
      if "|" in name:
         agentName, _ = name.split( "|" )
         allAgents[ agentName ] = f'{agentName} agent'
   return allAgents

schanAccelAgentMatcher = CliMatcher.DynamicKeywordMatcher(
   keywordsFn=schanAccelAgentNames,
   emptyTokenCompletion=AgentCli.allAgentCompletion )

# --------------------------------------------------------------------------------
# show platform AGENT_NAME statistics
# --------------------------------------------------------------------------------
class ShowAgentDurationStatsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show platform AGENT_NAME statistics'

   data = {
            'platform': platformMatcherForShow,
            'AGENT_NAME': schanAccelAgentMatcher,
            'statistics': CliCommand.guardedKeyword(
                           'statistics',
                           helpdesc='SchanAccel host-cpu command batch statistics',
                           guard=schanAccelEnabledGuard ),
   }

   cliModel = "SchanAccelCmdBatchStatsModel.AgentStat"
   handler = "SchanAccelCmdBatchStatsHandler.showAgentCmdStatsHandler"

if toggleSchanAccelCmdBatchTrackingEnabled():
   BasicCli.addShowCommandClass( ShowAgentDurationStatsCmd )

def Plugin( entityManager ):
   pass
