#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import CmdExtension
import BasicCliModes
import CliCommand
from CliToken.Platform import platformMatcherForExec
from CliPlugin.SfeCliLib import nodeSfeEos
import sys

#-------------------------------------------------------------------------------
# "platform sfe bessctl" hidden command, from "exec" mode.
#-------------------------------------------------------------------------------

# The bessctl shell is interactive. This command emulates if a user from bash
# opened /usr/share/bess/bessctl/bessctl.

def gotoBessctlMode( mode, args ):
   env = os.environ.copy()
   env[ 'SHELL' ] = '/bin/bash'
   env[ 'EOSCLIRUNNING' ] = '1'
   try:
      cliCmdExt = CmdExtension.getCmdExtender()
      cliCmdExt.subprocessPopen( [ '/usr/share/bess/bessctl/bessctl' ], mode.session,
         stdin=sys.stdin, stdout=sys.stdout, stderr=sys.stderr, env=env ).wait()
   except OSError as e:
      mode.addError( e.strerror )

class PlatformSfeBessctlCmd( CliCommand.CliCommandClass ):
   syntax = 'platform sfe bessctl'
   data = {
      'platform' : platformMatcherForExec,
      'sfe' : nodeSfeEos,
      'bessctl' : 'Enter bessctl cli shell',
   }

   hidden = True
   handler = gotoBessctlMode

BasicCliModes.EnableMode.addCommandClass( PlatformSfeBessctlCmd )
