#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from io import StringIO
import BasicCli
import AgentCommandRequest
import SfeAgent
import ShowCommand
import ast
from CliPlugin.SfeCliLib import nodeSfe
from CliPlugin.SfeIpsecShowCliModel import SfeIpsecShowCountersModel, \
         SfeIpsecShowCountersSwModel, SfeIpsecShowCountersErrModel, \
         SfeIpsecShowCountersDetModel, SfeIpsecShowStateModel, \
         SfeIpsecShowStateDetailModel, SfeIpsecShowStateEncapsulationModel, \
         SfeIpsecShowCountersHwModel
from CliToken.Platform import platformMatcherForShow
import Toggles.SfeToggleLib as Toggle

#
# Common handler
#
def showIpsecHandler( mode, cmd, model ):
   buff = StringIO()
   AgentCommandRequest.runSocketCommand( mode.entityManager, SfeAgent.name(),
                                      "sfe", cmd, stringBuff=buff,
                                      timeout=150, keepalive=True )
   output = buff.getvalue()
   try:
      data = ast.literal_eval( output )
   except SyntaxError:
      mode.addError( output )
      return None

   model.setAttrsFromDict( data )
   return model



# ---------------------------------------------------------------------------------
# show platform sfe ipsec counters
# ---------------------------------------------------------------------------------
class PlatformSfeIpsecCountersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = """show platform sfe ipsec counters"""
   data = {
      'platform' : platformMatcherForShow,
      'sfe' : nodeSfe,
      'ipsec' : 'IPsec information',
      'counters' : 'Aggregate of software and hardware IPsec counters',
   }

   cliModel = SfeIpsecShowCountersModel
   privileged = True

   @staticmethod
   def handler( mode, args ):
      cmd = 'IPSECcnt'
      model = SfeIpsecShowCountersModel()
      return showIpsecHandler( mode, cmd, model )

if Toggle.toggleSfeIpsecCliEnabled():
   BasicCli.addShowCommandClass( PlatformSfeIpsecCountersCmd )

class PlatformSfeIpsecCountersSwCmd( ShowCommand.ShowCliCommandClass ):
   syntax = """show platform sfe ipsec counters software"""
   data = {
      'platform' : platformMatcherForShow,
      'sfe' : nodeSfe,
      'ipsec' : 'IPsec information',
      'counters' : 'Aggregate of software and hardware IPsec counters',
      'software' : 'Software specific IPsec counters',
   }

   cliModel = SfeIpsecShowCountersSwModel
   privileged = True

   @staticmethod
   def handler( mode, args ):
      cmd = 'IPSECcntsw'
      model = SfeIpsecShowCountersSwModel()
      return showIpsecHandler( mode, cmd, model )

if Toggle.toggleSfeIpsecCliEnabled():
   BasicCli.addShowCommandClass( PlatformSfeIpsecCountersSwCmd )

class PlatformSfeIpsecCountersHwCmd( ShowCommand.ShowCliCommandClass ):
   syntax = """show platform sfe ipsec counters hardware"""
   data = {
      'platform' : platformMatcherForShow,
      'sfe' : nodeSfe,
      'ipsec' : 'IPsec information',
      'counters' : 'Aggregate of software and hardware IPsec counters',
      'hardware' : 'Hardware specific IPsec counters',
   }

   cliModel = SfeIpsecShowCountersHwModel
   privileged = True

   @staticmethod
   def handler( mode, args ):
      cmd = 'IPSECcnthw'
      model = SfeIpsecShowCountersHwModel()
      return showIpsecHandler( mode, cmd, model )

if Toggle.toggleSfeIpsecCliEnabled():
   BasicCli.addShowCommandClass( PlatformSfeIpsecCountersHwCmd )

class PlatformSfeIpsecCountersErrCmd( ShowCommand.ShowCliCommandClass ):
   syntax = """show platform sfe ipsec counters error"""
   data = {
      'platform' : platformMatcherForShow,
      'sfe' : nodeSfe,
      'ipsec' : 'IPsec information',
      'counters' : 'Aggregate of software and hardware IPsec counters',
      'error' : 'IPsec error counters',
   }

   cliModel = SfeIpsecShowCountersErrModel
   privileged = True

   @staticmethod
   def handler( mode, args ):
      cmd = 'IPSECcnterr'
      model = SfeIpsecShowCountersErrModel()
      return showIpsecHandler( mode, cmd, model )

if Toggle.toggleSfeIpsecCliEnabled():
   BasicCli.addShowCommandClass( PlatformSfeIpsecCountersErrCmd )

class PlatformSfeIpsecCountersDetCmd( ShowCommand.ShowCliCommandClass ):
   syntax = """show platform sfe ipsec counters detail"""
   data = {
      'platform' : platformMatcherForShow,
      'sfe' : nodeSfe,
      'ipsec' : 'IPsec information',
      'counters' : 'Aggregate of software and hardware IPsec counters',
      'detail' : 'Detailed IPsec counters',
   }

   cliModel = SfeIpsecShowCountersDetModel
   privileged = True

   @staticmethod
   def handler( mode, args ):
      cmd = 'IPSECcntdet'
      model = SfeIpsecShowCountersDetModel()
      return showIpsecHandler( mode, cmd, model )

if Toggle.toggleSfeIpsecCliEnabled():
   BasicCli.addShowCommandClass( PlatformSfeIpsecCountersDetCmd )

class PlatformSfeIpsecStateCmd( ShowCommand.ShowCliCommandClass ):
   syntax = """show platform sfe ipsec state"""
   data = {
      'platform' : platformMatcherForShow,
      'sfe' : nodeSfe,
      'ipsec' : 'IPsec information',
      'state' : 'IPsec state',
   }

   cliModel = SfeIpsecShowStateModel
   privileged = True

   @staticmethod
   def handler( mode, args ):
      cmd = 'IPSECstate'
      model = SfeIpsecShowStateModel()
      return showIpsecHandler( mode, cmd, model )

if Toggle.toggleSfeIpsecCliShowStateCmdEnabled():
   BasicCli.addShowCommandClass( PlatformSfeIpsecStateCmd )

class PlatformSfeIpsecStateDetCmd( ShowCommand.ShowCliCommandClass ):
   syntax = """show platform sfe ipsec state detail"""
   data = {
      'platform' : platformMatcherForShow,
      'sfe' : nodeSfe,
      'ipsec' : 'IPsec information',
      'state' : 'IPsec state',
      'detail' : 'Display information in detail',
   }

   cliModel = SfeIpsecShowStateDetailModel
   privileged = True

   @staticmethod
   def handler( mode, args ):
      cmd = 'IPSECstate'
      model = SfeIpsecShowStateDetailModel()
      return showIpsecHandler( mode, cmd, model )

if Toggle.toggleSfeIpsecCliShowStateCmdEnabled():
   BasicCli.addShowCommandClass( PlatformSfeIpsecStateDetCmd )

class PlatformSfeIpsecStateEncapsulationCmd( ShowCommand.ShowCliCommandClass ):
   syntax = """show platform sfe ipsec state encapsulation"""
   data = {
      'platform' : platformMatcherForShow,
      'sfe' : nodeSfe,
      'ipsec' : 'IPsec information',
      'state' : 'IPsec state',
      'encapsulation' : 'Display information grouped by Encap ID',
   }

   cliModel = SfeIpsecShowStateEncapsulationModel
   privileged = True

   @staticmethod
   def handler( mode, args ):
      cmd = 'IPSECstate'
      model = SfeIpsecShowStateEncapsulationModel()
      return showIpsecHandler( mode, cmd, model )

if Toggle.toggleSfeIpsecCliShowStateCmdEnabled():
   BasicCli.addShowCommandClass( PlatformSfeIpsecStateEncapsulationCmd )
