#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
#import CliParser, BasicCli
import CliPlugin.SfeL3UnicastShowVxlanCliModel as SfeL3Model
from CliPlugin import SfeCliLib
import AgentCommandRequest
from io import StringIO

#---------------------------------------------------------------------------------
# show platform sfe [hardware] vxlan tunnel-ivif [<remote-vtep-ip>]
#---------------------------------------------------------------------------------
# pylint: disable=eval-used
def doShowTunnelIvif( mode, hardware, vtepIp ):
   command = ''
   if hardware:
      command += "hardware+"
   command += "showtunnelivif+"
   if vtepIp:
      command += vtepIp
   buff = StringIO()
   AgentCommandRequest.runSocketCommand( mode.entityManager,
                                         "sfeL3Unicast", "sfeL3Unicast",
                                         command, stringBuff=buff )

   output = buff.getvalue()
   model = SfeL3Model.SfeL3UnicastTunnelIvifModel()
   try:
      model.setAttrFromDict( eval( output ) )
   except SyntaxError:
      mode.addError( "Error: Unable to retrieve information from SfeL3Unicast" )
      return None
   return model

# Please update this command with the new CLI parser ( AID5819 ) when uncomment it
#DISABLE FOR NOW
#BasicCli.registerShowCommand( SfeCliLib.tokenPlatformForShow,
#                              SfeCliLib.tokenOptionalHardware,
#                              SfeCliLib.tokenVxlan,
#                              tokenTunnelIvif,
#                              tokenOptionalVtepIp,
#                              doShowTunnelIvif,
#                              privileged=True,
#                              cliModel=SfeL3Model.SfeL3UnicastTunnelIvifModel )

#---------------------------------------------------------------------------------
# show platform sfe [hardware] vxlan local-vtep [<local-vtep-ip>]
#---------------------------------------------------------------------------------
# pylint: disable=eval-used
def doShowLocalVtep( mode, hardware, vtepIp ):
   command = ''
   if hardware:
      command += "hardware+"
   command += "showlocalvtep+"
   if vtepIp:
      command += vtepIp
   buff = StringIO()
   AgentCommandRequest.runSocketCommand( mode.entityManager,
                                         "sfeL3Unicast", "sfeL3Unicast",
                                         command, stringBuff=buff )

   output = buff.getvalue()
   model = SfeL3Model.SfeL3UnicastLocalVtepModel()
   try:
      model.setAttrFromDict( eval( output ) )
   except SyntaxError:
      mode.addError( "Error: Unable to retrieve information from SfeL3Unicast" )
      return None
   return model

# Please update this command with the new CLI parser ( AID5819 ) when uncomment it
#DISABLE FOR NOW
#BasicCli.registerShowCommand( SfeCliLib.tokenPlatformForShow,
#                              SfeCliLib.tokenOptionalHardware,
#                              SfeCliLib.tokenVxlan,
#                              tokenLocalVtep,
#                              tokenOptionalVtepIp,
#                              doShowLocalVtep,
#                              privileged=True,
#                              cliModel=SfeL3Model.SfeL3UnicastLocalVtepModel )

#---------------------------------------------------------------------------------
# show platform sfe [hardware] vxlan udp-port
#---------------------------------------------------------------------------------
# pylint: disable=eval-used
def doShowUdpPort( mode, hardware ):
   command = ''
   if hardware:
      command += "hardware+"
   command += "showudpport"
   buff = StringIO()
   AgentCommandRequest.runSocketCommand( mode.entityManager,
                                         "sfeL3Unicast", "sfeL3Unicast",
                                         command, stringBuff=buff )

   output = buff.getvalue()
   model = SfeL3Model.SfeL3UnicastVxlanUdpPortModel()
   try:
      model.setAttrFromDict( eval( output ) )
   except SyntaxError:
      mode.addError( "Error: Unable to retrieve information from SfeL3Unicast" )
      return None
   return model

# Please update this command with the new CLI parser ( AID5819 ) when uncomment it
#DISABLE FOR NOW
#BasicCli.registerShowCommand( SfeCliLib.tokenPlatformForShow,
#                              SfeCliLib.tokenOptionalHardware,
#                              SfeCliLib.tokenVxlan,
#                              tokenUdpPort,
#                              doShowUdpPort,
#                              privileged=True,
#                              cliModel=SfeL3Model.SfeL3UnicastVxlanUdpPortModel )

#---------------------------------------------------------------------------------
# show platform sfe [hardware] vxlan remote-vtep [<remote-vtep-ip>]
#---------------------------------------------------------------------------------
# pylint: disable=eval-used
def doShowTunnelInfo( mode, hardware, vtepIp ):
   command = ''
   if hardware:
      command += "hardware+"
   command += "showremotevteps+"
   if vtepIp:
      command += vtepIp
   buff = StringIO()
   AgentCommandRequest.runSocketCommand( mode.entityManager,
                                         "sfeL3Unicast", "sfeL3Unicast",
                                         command, stringBuff=buff )

   output = buff.getvalue()
   model = SfeL3Model.SfeL3UnicastRemoteVtepModel()
   try:
      model.setAttrFromDict( eval( output ) )
   except SyntaxError:
      mode.addError( "Error: Unable to retrieve information from SfeL3Unicast" )
      return None
   return model

# Please update this command with the new CLI parser ( AID5819 ) when uncomment it
#DISABLE FOR NOW
#BasicCli.registerShowCommand( SfeCliLib.tokenPlatformForShow,
#                              SfeCliLib.tokenOptionalHardware,
#                              SfeCliLib.tokenVxlan,
#                              tokenRemoteVtep,
#                              tokenOptionalVtepIp,
#                              doShowTunnelInfo,
#                              privileged=True,
#                              cliModel=SfeL3Model.SfeL3UnicastRemoteVtepModel )

#---------------------------------------------------------------------------------
# show platform sfe vxlan summary
#---------------------------------------------------------------------------------
# pylint: disable=eval-used
def doShowVxlanSummary( mode ):
   command = 'vxlansumm+'
   buff = StringIO()
   model = SfeL3Model.SfeVxlanSummaryModel()
   # though we call SfeMact agentCommand here, we are not introducing any
   # dependency between SfeL3Unicast and SfeMact.
   isSfeL3UnicastRunning = SfeCliLib.isSfeAgentRunning(
      mode.entityManager.sysname(), 'SfeL3Unicast' )
   isSfeMactRunning = SfeCliLib.isSfeAgentRunning(
      mode.entityManager.sysname(), 'SfeMact' )

   if isSfeL3UnicastRunning and isSfeMactRunning:
      AgentCommandRequest.runSocketCommand( mode.entityManager,
                                            "sfeL3Unicast", "sfeL3Unicast",
                                            command, stringBuff=buff )

      AgentCommandRequest.runSocketCommand( mode.entityManager,
                                            "sfeMact", "sfeMact",
                                            command, stringBuff=buff )
      output = buff.getvalue()
      model.setAttrFromDict( eval( output )[ 'vlxanSummary' ] )
      return model
   elif not isSfeL3UnicastRunning and not isSfeMactRunning:
      mode.addError( " SfeL3Unicast and SfeMact agents are not running" )
   elif not isSfeMactRunning:
      mode.addError( " SfeMact agent is not running" )
   else:
      mode.addError( " SfeL3Unicast agent is not running" )
   return None

# Please update this command with the new CLI parser ( AID5819 ) when uncomment it
#DISABLE FOR NOW
#BasicCli.registerShowCommand( SfeCliLib.tokenPlatformForShow,
#                              SfeCliLib.tokenVxlan,
#                              tokenVxlanSummary,
#                              doShowVxlanSummary,
#                              privileged=True,
#                              cliModel=SfeL3Model.SfeVxlanSummaryModel )

#---------------------------------------------------------------------------------
# show platform sfe [hardware] vxlan flood-vif [<vlan-id>]
#---------------------------------------------------------------------------------
def doShowVlanFloodVifInfo( mode, hardware, vlan ):
   command1 = ''
   if hardware:
      command1 += "hardware+"
   command2 = command1
   command1 += "showfloodvifinfo+"
   if vlan:
      command1 += "vlanId" + str( vlan ) + "+"
   buff = StringIO()
   AgentCommandRequest.runSocketCommand( mode.entityManager, "sfeMcast",
                                         "sfeMcast", command1, stringBuff=buff )
   try:
      dataDict = eval( buff.getvalue() )
   except  SyntaxError:
      mode.addError( "Error: Unable to retrieve information from SfeMcast" )
      return None

   if 'cmdErr' not in dataDict[ 'vlanfloodVifInfo' ]:
      tunInfoIds = dataDict['vlanfloodVifInfo']['tunInfoIds']
      del dataDict['vlanfloodVifInfo']['tunInfoIds']
      command2 += 'getTunInfo+' + tunInfoIds
      buff = StringIO()

      AgentCommandRequest.runSocketCommand( mode.entityManager,
                                            "sfeL3Unicast", "sfeL3Unicast",
                                            command2, stringBuff=buff )
      try:
         tunInfoDict = eval( buff.getvalue() )
      except  SyntaxError:
         mode.addError( "Error: Unable to retrieve information \
         from SfeL3Unicast" )
         return None
      for vlanId, info in dataDict[ 'vlanfloodVifInfo' ].items():
         for mdtIdx, mdtInfo in info.items():
            if mdtInfo[ 'mdtType' ] == 'remoteVtep':
               tunInfo = list( mdtInfo[ 'tunnelInfo' ] )
               dataDict['vlanfloodVifInfo'][ vlanId ][ mdtIdx ][ 'tunnelInfo' ]\
                  [ tunInfo[0] ] = tunInfoDict[ 'vteps' ][ tunInfo[0] ]

   model = SfeL3Model.SfeMcastVlanFloodVifInfoModel()
   model.setAttrsFromDict( dataDict )
   return model

# Please update this command with the new CLI parser ( AID5819 ) when uncomment it
#DISABLE FOR NOW
#BasicCli.registerShowCommand( SfeCliLib.tokenPlatformForShow,
#                              SfeCliLib.tokenOptionalHardware,
#                              SfeCliLib.tokenVxlan,
#                              tokenFloodVif,
#                              vlanIdOpt,
#                              doShowVlanFloodVifInfo,
#                              privileged=True,
#                              cliModel=SfeL3Model.SfeMcastVlanFloodVifInfoModel )

