# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Int, Model, Str, List, Bool

class MempoolStatsModel( Model ):
   poolIndex = Int( help='Pool index' )
   name = Str( help='Name' )
   dpdkNamePrefix = Str( help='String used as a common prefix of all underlying '
                              'memory pools\' names' )
   initialized = Bool( help='Initialized' )
   memoryPoolsCount = Int( help='Count of the underlying memory pools' )
   capacity = Int( help='Overall capacity' )
   capacityLimit = Int( help='Overall capacity limit' )
   entriesInUse = Int( help='Entries in use' )
   entriesAvailable = Int( help='Entries available' )
   entrySize = Int( help='One entry size in bytes' )
   growthFailsCapacityLimit = Int(
      help='Count of the memory pool growth fails due to the overall capacit limit' )
   growthFailsOverall = Int( help='Count of the memory pool growth fails overall' )
   freeMemoryPoolsMap = Str(
           help='Underlying memory pools bit map - 0: full, 1: free' )

class MemoryPoolShowModel( Model ):
   memoryPools = List( valueType=MempoolStatsModel, help='List of all memory pools' )
