#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliPlugin.TechSupportCli
from CliPlugin import SfeCliLib, PciCli
from Toggles.DpsToggleLib import toggleFlowAssignmentLanEnabled
from Toggles.SfeToggleLib import toggleSfeIpsecCliShowStateCmdEnabled
from Toggles.SfeToggleLib import toggleSfeMcastEnabled
from Toggles.EosInitToggleLib import toggleSfeVrfScaleEnabled
from Toggles.EosInitToggleLib import toggleSfeVrfScalev2Enabled

SHOW_TECH_CMDS = [
   'show platform sfe counters',
   'show platform sfe l3 next-hops',
   'show platform sfe l3 unicast summary',
   'show platform sfe ip route',
   'show platform sfe mirroring',
   'show cpu counters queue | nz',
   'show interfaces counters queue detail | nz',
   'show interface counters discard | nz',
   'show platform sfe qos',
   'show platform sfe status',
   'show platform sfe worker summary all',
   'show platform sfe memory pool',
   'show agent Sfe logs',
   'bash /usr/bin/GenBessInfo',
   'bash ifconfig -a',
   'bash lscpu',
   'bash sudo /usr/bin/GenDpdkProcInfo',
]

# Commands that should only run on vEOS platform
VEOS_PLATFORM_CMDS = [
   'show platform sfe l3 next-hops diff',
   'show platform sfe flow tracking counters',
   'show flow tracking hardware counters',
   'show flow tracking hardware',
   # multiline string below
   'bash for i in `ip link | egrep -o "et[0-9]+:|et[0-9]+_[0-9]+:" |'
   'tr \'\n\' \' \' | sed s/://g`; do echo $i; ethtool -S $i; done',
]

# These commands overlap on new Caravan systems that are
# not vEOS platforms. In this case, both PciBus and
# Sfe are running, and there's no need to duplicate these
# commands
PCIBUS_INTERDEPENDENT_CMDS = [
      'bash lspci',
]

NAT_MGR_CMDS = [
      'show platform sfe nat pool detail',
      'show platform sfe nat mempool',
      'show platform sfe nat module pool-mgr',
      'show platform sfe nat module snat',
      'show platform sfe nat module dnat',
      'show platform sfe nat module flow-cache',
      'show platform sfe nat module twice',
      'show platform sfe nat counters',
      'show ip nat translation summary',
]

AVT_CMDS = [
      'show adaptive-virtual-topology flow',
      'show adaptive-virtual-topology path',
      'bash bessctl show avt flow-info',
      'bash bessctl show avt bestpath',
      'bash bessctl show avt mh-path',
      'bash bessctl show avt avt-lookup'
]

AVT_COUNTER_CMDS = [
     'show adaptive-virtual-topology path counters'
]

HA_CMDS = [
      'bash bessctl show ha counters *',
      'bash bessctl show ha state'
]

DPI_CMDS = [
     'show application traffic recognition counters debug'
]

IE_CMDS = [
   "show internet-exit policy"
]

SI_CMDS = [
   "show service-insertion connection"
]

IPSEC_CMDS = [
   "show platform sfe ipsec counters",
   "show platform sfe ipsec counters error",
]

IPSEC_NEW_CMDS = [
   "show platform sfe ipsec state",
]

MULTICAST_CMDS = [
   "show platform sfe mroute ipv4",
   "show platform sfe multicast interface counter ipv4",
   "show platform sfe counters module MfibIpv4default"
]

FIB_CMDS = [
   'show platform sfe ip fib state',
]

RUBY2_CMDS = [
   'show flow tracking firewall distributed counters',
]

SHOW_TECH_CMDS.extend( NAT_MGR_CMDS )

SHOW_TECH_CMDS.extend( IPSEC_CMDS )

SHOW_TECH_CMDS.extend( IE_CMDS )

SHOW_TECH_CMDS.extend( AVT_CMDS )

if toggleFlowAssignmentLanEnabled():
   SHOW_TECH_CMDS.extend( HA_CMDS )

SHOW_TECH_CMDS.extend( AVT_COUNTER_CMDS )

SHOW_TECH_CMDS.extend( DPI_CMDS )

SHOW_TECH_CMDS.extend( SI_CMDS )

if toggleSfeIpsecCliShowStateCmdEnabled():
   SHOW_TECH_CMDS.extend( IPSEC_NEW_CMDS )

if toggleSfeMcastEnabled():
   SHOW_TECH_CMDS.extend( MULTICAST_CMDS )

if toggleSfeVrfScaleEnabled() or toggleSfeVrfScalev2Enabled():
   SHOW_TECH_CMDS.extend( FIB_CMDS )

def _SfeShowTechGuard():
   # Ensure that Sfe is running before issuing commands for it
   assert SfeCliLib.entityManager
   return SfeCliLib.isSfeAgentRunning( SfeCliLib.entityManager.sysname(), 'Sfe' )

def _NotHwPlatformShowTechGuard():
   # notHwPlatform returns None when on vEOS platform
   return _SfeShowTechGuard() and not SfeCliLib.notHwPlatform( None, None )

def _NotRuby2ShowTechGuard():
   # returns True only for Ruby platform.
   # returns None and guards for other platform.
   return _SfeShowTechGuard() and SfeCliLib.notRubyDfw( None, None )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2018-09-17 23:00:00',
   cmds=SHOW_TECH_CMDS,
   cmdsGuard=_SfeShowTechGuard )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2018-09-17 23:00:00',
   cmds=SHOW_TECH_CMDS,
   cmdsGuard=_SfeShowTechGuard,
   extended='sfe' )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2018-09-17 23:00:00',
   cmds=VEOS_PLATFORM_CMDS,
   cmdsGuard=_NotHwPlatformShowTechGuard,
   summaryCmdsGuard=_NotHwPlatformShowTechGuard )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2023-01-11 11:00:00',
   cmds=PCIBUS_INTERDEPENDENT_CMDS,
   cmdsGuard=lambda: not PciCli.showTechGuard() )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2024-06-11 10:00:00',
   cmds=RUBY2_CMDS,
   cmdsGuard=_NotRuby2ShowTechGuard )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2024-06-11 10:00:00',
   cmds=RUBY2_CMDS,
   cmdsGuard=_NotRuby2ShowTechGuard, extended='sfe' )
