#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliMatcher
from CliPlugin import SflowCli
from CliToken.Clear import clearKwNode

#--------------------------------------------------------------------------------
# clear sflow counters
#--------------------------------------------------------------------------------
class ClearSflowCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear sflow counters'
   data = {
      'clear' : clearKwNode,
      'sflow' : CliCommand.Node(
         matcher=CliMatcher.KeywordMatcher( 'sflow',
            helpdesc='Clear sFlow information' ),
         guard=SflowCli.sflowSupportedGuard ),
      'counters' : 'Clear sFlow global counters',
   }
   handler = SflowCli.setCountersCleared

BasicCliModes.EnableMode.addCommandClass( ClearSflowCountersCmd )
