#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliMatcher
import CliPlugin.SflowCli as SflowCli # pylint: disable=consider-using-from-import
from CliPlugin.SflowModel import SflowInterfaces, SflowStatus, SflowInterfaceCounters
import ShowCommand

matcherSflow = CliMatcher.KeywordMatcher( 'sflow',
      helpdesc='sFlow Information' )
nodeSflow = CliCommand.Node( matcher=matcherSflow,
      guard=SflowCli.sflowSupportedGuard )

#--------------------------------------------------------------------------------
# show sflow
#--------------------------------------------------------------------------------
class SflowCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show sflow [ detail ]'
   data = {
      'sflow' : nodeSflow,
      'detail' : 'Detailed sFlow information',
   }
   handler = SflowCli.doShowSflow
   cliModel = SflowStatus
   prepareFunction = SflowCli.doPrepShowSflow

BasicCli.addShowCommandClass( SflowCmd )

#--------------------------------------------------------------------------------
# show sflow interfaces [ detail ]
#--------------------------------------------------------------------------------
class SflowInterfacesCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show sflow interfaces [ detail ]'
   data = {
      'sflow' : nodeSflow,
      'interfaces' : 'Show sFlow interfaces',
      'detail' : 'Detailed sFlow interfaces information',
   }
   handler = SflowCli.doShowSflowIntfs
   cliModel = SflowInterfaces

BasicCli.addShowCommandClass( SflowInterfacesCmd )

# --------------------------------------------------------------------------------
# show sflow interfaces counters
# --------------------------------------------------------------------------------
class SflowInterfaceCountersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show sflow interfaces counters'
   data = {
      'sflow' : nodeSflow,
      'interfaces' : 'Show sFlow interfaces',
      'counters' : 'Show sFlow interfaces sample counters',
   }
   handler = SflowCli.doShowSflowIntfCounters
   cliModel = SflowInterfaceCounters
   prepareFunction = SflowCli.doPrepShowSflow

BasicCli.addShowCommandClass( SflowInterfaceCountersCmd )
