# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliPlugin.TechSupportCli
from CliPlugin.FlowTrackingCliLib import isSftAgentRunning
import LazyMount

activeAgentDir = None
entityManager = None

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2019-01-16 16:10:20',
   cmds=[ 'show flow tracking sampled',
          'show flow tracking sampled counters',
          'show flow tracking sampled counters interface error',
          'show flow tracking sampled counters debug',
        ],
   cmdsGuard=lambda: isSftAgentRunning( entityManager, activeAgentDir ) )

def Plugin( em ):
   global activeAgentDir
   global entityManager
   entityManager = em
   activeAgentDir = LazyMount.mount( em, 'flowtracking/activeAgent',
                                     'Tac::Dir', 'ri' )
