#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import ShowCommand
from CliPlugin.ShowConfigConsistencyCliModels import ConfigConsistencyMultiTableModel
from ConfigConsistencyChecker import ConfigConsistencyChecker
from Toggles.ConfigConsistencyToggleLib import toggleConfigConsistencyAvtCmdEnabled
import Tac

# --------------------------------------------------------------------------------
# show configuration consistency adpative-virtual-topology
# --------------------------------------------------------------------------------
def showConfigurationConsistencyAvt( mode, args ):
   ClusterChecker = ConfigConsistencyChecker.getClusterChecker(
                                          'adaptive-virtual-topology' )
   return ClusterChecker.check( args.get( 'CATEGORIES' ), mode, args )

class ShowConfigConsistencyAvtCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show configuration consistency adaptive-virtual-topology'
   data = {
         'configuration': 'Show configuration information',
         'consistency': 'Verify configuration consistency',
         'adaptive-virtual-topology': ConfigConsistencyChecker.getClusterChecker(
                  'adaptive-virtual-topology' ).clusterMatcher(),
   }

   handler = showConfigurationConsistencyAvt
   cliModel = ConfigConsistencyMultiTableModel

if toggleConfigConsistencyAvtCmdEnabled():
   BasicCli.addShowCommandClass( ShowConfigConsistencyAvtCmd )
