#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import ShowCommand
from CliPlugin.ShowConfigConsistencyCliModels import ConfigConsistencyMultiTableModel
from ConfigConsistencyChecker import ConfigConsistencyChecker
from Toggles.ConfigConsistencyToggleLib import toggleConfigConsistencyNatCmdEnabled


# --------------------------------------------------------------------------------
# show configuration consistency nat [ { access-list | hardware-tables } ]
# --------------------------------------------------------------------------------
def showConfigurationConsistencyNat( mode, args ):
   ClusterChecker = ConfigConsistencyChecker.getClusterChecker( 'nat' )
   return ClusterChecker.check( args.get( 'CATEGORIES' ), mode, args )

class ShowConfigConsistencyNatCmd( ShowCommand.ShowCliCommandClass ):
   syntax = "show configuration consistency ( nat [ CATEGORIES ] )"
   data = {
         "configuration": "Show configuration information",
         "consistency": "Verify configuration consistency",
         "nat": ConfigConsistencyChecker.getClusterChecker(
                  'nat' ).clusterMatcher(),
         "CATEGORIES": ConfigConsistencyChecker.getClusterChecker(
                        'nat' ).categoryMatcher()
   }

   handler = showConfigurationConsistencyNat
   cliModel = ConfigConsistencyMultiTableModel

if toggleConfigConsistencyNatCmdEnabled():
   BasicCli.addShowCommandClass( ShowConfigConsistencyNatCmd )
