# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliMatcher
import CliToken.Hardware
import ShowCommand
import Toggles.LedPolicyToggleLib

# -----------------------------------------------------------------------------
# show hardware led [ name NAME ]
#
# Shows the lightSetting values of leds. Improved from `show led`.
# -----------------------------------------------------------------------------
class ShowHardwareLedSettings( ShowCommand.ShowCliCommandClass ):
   syntax = 'show hardware led [ name NAME ]'
   # Note that for NAME, we are just grabbing the string itself.
   data = {
      'hardware': CliToken.Hardware.hardwareMatcherForShow,
      'led': 'Show LED information',
      'name': 'Show LED Light Settings by name',
      'NAME': CliMatcher.PatternMatcher( pattern=r'\S+',
                                         helpdesc='Component name',
                                         helpname='WORD' )
   }
   cliModel = "ShowHardwareLedModel.HardwareLedSettings"
   handler = "ShowHardwareLedHandler.showHardwareLedHandler"

if Toggles.LedPolicyToggleLib.toggleShowHardwareLedEnabled():
   BasicCli.addShowCommandClass( ShowHardwareLedSettings )
