#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli, ShowCommand, CliMatcher
from CliToken.Debugging import debuggingMatcherForShow
from CliPlugin import InotifyModel

inotifyMatcherForShow = 'Show inotify usage information'

class InotifyShowFilesCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show debugging inotify file pid PID'
   data = {
      'debugging' : debuggingMatcherForShow,
      'inotify' : inotifyMatcherForShow,
      'file' : 'Show files being watched using inotify',
      'pid' : 'Show files being watched by a given PID using inotify',
      'PID' : CliMatcher.IntegerMatcher( lbound=0, ubound=4194304,
         helpdesc='Process identifier' ),
   }
   cliModel = "InotifyModel.InotifyQueryFilesModel"
   handler = "InotifyCliHandler.InotifyShowFilesCmdHandler"
   privileged = True

class InotifyShowCmd( ShowCommand.ShowCliCommandClass ):
   # This command requires the Cli to be run as root.
   # eg: `sudo FastCli -A`
   #
   # For physical duts, you can run the following:
   # ```
   # glf418(s1)> en
   # glf418(s1)# bash
   # [admin@glf418 ~]$ sudo FastCli -A
   # ```
   syntax = 'show debugging inotify ( QUERY | all )'
   data = {
      'debugging' : debuggingMatcherForShow,
      'inotify' : inotifyMatcherForShow,
      'QUERY' : CliMatcher.EnumMatcher( InotifyModel.ALL_QUERIES ),
      'all' : 'Run all the inotify subcommands',
   }
   cliModel = "InotifyModel.InotifyQueryModel"
   handler = "InotifyCliHandler.InotifyShowCmdHandler"
   privileged = True

BasicCli.addShowCommandClass( InotifyShowCmd )
BasicCli.addShowCommandClass( InotifyShowFilesCmd )
