# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Model, Str

# This file just import the real model from the base directory.  Usually models are
# in the CliPlugin directory but we couldn't do this here because of issues
# with loadPlugins and path resolution.
# The issue occurs in the following sequence:
# - A test imports CliApi.py that imports SystemUrl.py via loadPlugins.
# - SystemUrl.py imports CliSave.py.  The CliSave.py load was flagging an error
#  that it couldn't find the Model if it was located on the CliPlugin directory.
import ShowRunOutputModel # pylint: disable=unused-import

class RunningConfigDigest( Model ):
   digest = Str( help="Message digest for running-config" )

   def render( self ):
      print( self.digest )


