# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AgentCommandRequest
import ShowCommand
from CliToken import Agent

def ShowS4SyncDebugClassFactory( *,
                                 agentName,
                                 agentHelpDesc,
                                 privilegedMode=False ):
   class ShowAgentDebugS4SyncCommand( ShowCommand.ShowCliCommandClass ):
      syntax = f"show agent {agentName} debug sync"
      data = {
         "agent": Agent.agentKwForShow,
         agentName: agentHelpDesc,
         "debug": "Agent's debugging information",
         "sync": "Debugging synced state in the agent"
      }
      # Default for privilegedMode is False in order to match behavior
      # of "show agent {agentName} debug" command.
      privileged = privilegedMode

      @staticmethod
      def handler( mode, args ):
         AgentCommandRequest.runSocketCommand( mode.entityManager,
                                               agentName,
                                               'dumpStateS4SyncModule', "" )

   ShowAgentDebugS4SyncCommand.__name__ = f"ShowAgent{agentName}DebugS4SyncCommand"
   return ShowAgentDebugS4SyncCommand
