# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-msg=F0401
import CliPlugin.TechSupportCli

#------------------------------------------------------------------------------------
# The "show tech-support" command
#------------------------------------------------------------------------------------

# Legacy implementation of the list of commands to run as part of
# "show tech-support".
# PLEASE DO NOT ADD ANY MORE COMMANDS HERE!
#
# Please register your own commands to add to "show tech-support"
# using your own call to registerShowTechSupportCmd in your
# own CliPlugin.
#
# See //src/Cli/CliPlugin/TechSupportCli.py for instructions.

# PLEASE DO NOT ADD ANY MORE COMMANDS HERE!
#
# See comment at the beginning of this function for
# instructions for how to add your own commands to "show
# tech-support".

#The following commands grouped together to maintain historical ordering of
#'show tech-support' command. Do not insert any new commands into this list.
#If you are trying to register a new Eos show command with show tech-support
#then create a new group and select a timestamp such that the command gets
#registered at the end. If it is absolutely necessary to insert it in the
#middle, discuss first with the TAC team

# These are the original show tech commands.  We use a low time stamp when
# registering to make sure they come ahead of all other commands.  
# Timestamps are made up to maintain historical order within show tech-support
CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2010-01-01 00:00:00',
   cmds=[ 'show version detail' ],
   summaryCmds=[ 'show version detail' ] )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2010-01-01 00:02:00',
   cmds=[ 'show running-config sanitized' ] )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2010-01-01 00:04:00',
   cmds=[ 'show interfaces all',
          'show interfaces all status' ],
   summaryCmds=[ 'show interfaces all status' ] )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2010-01-01 00:04:30',
   cmds=[ 'show interfaces all phy detail',
          'show interfaces counters queue | nz' ],
   summaryCmds=[ 'show interfaces counters queue | nz' ] )

# Retaining 'show ip interface' registration with Eos package
# instead of moving it to Ira package because of difficulty in
# verifying the output of that command from within Ira package
CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2010-01-01 00:05:40',
   cmds=[ 'show ip interface' ] )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2010-01-01 00:17:00',
   cmds=[ 'show inventory',
          'bash ls -ltr /var/log/agents',
          'bash ls -ltr /var/core' ],
   summaryCmds=[ 'show inventory',
                 'bash ls -ltr /var/log/agents',
                 'bash ls -ltr /var/core' ] )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2010-01-01 00:20:00',
    cmds=[ 'dir /recursive flash:',
           'bash df -h' ],
   summaryCmds=[ 'bash df -h' ] )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2016-12-21 06:05:00',
   cmds=[ 'bash free' ],
   summaryCmds=[ 'bash free' ] )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2023-07-11 14:00:00',
   cmds=[ 'bash sudo python3 /usr/bin/SysMemLoadReport.py' ],
   summaryCmds=[ 'bash sudo python3 /usr/bin/SysMemLoadReport.py' ] )
