# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
from CliToken.Debugging import debuggingMatcherForShow
import ShowCommand

#--------------------------------------------------------------------------------
# show debugging smash clients all
#--------------------------------------------------------------------------------
class SmashClientsAllCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show debugging smash clients all'
   data = {
      'debugging' : debuggingMatcherForShow,
      'smash' : 'Show information about Smash tables',
      'clients' : 'Show the clients of Smash tables',
      'all' : 'Show information for all Smash tables',
   }
   cliModel = "SmashModel.WhoAll"
   handler = "SmashCliHandler.SmashClientsAllCmdHandler"
   privileged = True

BasicCli.addShowCommandClass( SmashClientsAllCmd )
