#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from ArnetModel import IpGenericAddress
from CliModel import ( List,
                       Model,
                       Enum )
from IntfModels import Interface

# Though this is very similar to TunnelModels.MplsVia, we are deliberately not
# using that type here. This is because the fact that segment lists are currently
# using Tunnels to propagate their data to platform is not relevant to the user,
# and this implementation could be changed at any time, so there is no reason that
# this model should be tethered to tunnels.
class SrTeSegmentListVia( Model ):
   nexthop = IpGenericAddress( help="Next hop IP address" )
   interface = Interface( help="Egress L3 interface of the next hop" )
   mplsLabels = List( valueType=int, optional=True, help="MPLS label stack" )

invalidReasonEnum = Enum( values=( 'unresolvedTopLabel', 'segmentListMissing',
                               'noResolvedLabels',
                               'resolvedLabelsExceedPlatformMsd',
                               'sbfdDown' ),
                      optional=True,
                      help="Reason why this segment list is invalid" )
ProtectionStateEnum = Enum( values=( 'protectionUnknown', 'slProtected',
   'unprotectedTilfaBackupExceedMSD' ),
   optional=True,
   help="Segment list protection status and the reason why unprotected" )
