#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliMatcher
import Swag
from CliPlugin.LagCliLib import MemberId

#-----------------------------------------------------------
# Cli Guard
#-----------------------------------------------------------
def swagSupported( mode, token ):
   # Check on the sysdb state after the type gets defined. Allow the
   # CLI to take effect for now.
   return None

def swagNonMember( mode, token ):
   """
   Guard the CLI on SWAG members. The command is available on non-SWAG devices and
   SWAG candidate devices.
   """
   if Swag.isMember():
      return 'not supported on switch aggregation members'
   return None

# -----------------------------------------------------------
# Matcher
# -----------------------------------------------------------
memberMatcher = CliCommand.guardedKeyword(
   'member', helpdesc="Configure switch aggregation member",
   guard=swagNonMember )
memberIdTokenMatcher = CliMatcher.KeywordMatcher(
   'id', helpdesc="Configure switch aggregation member identifier" )
memberIdValueMatcher = CliMatcher.IntegerMatcher(
   MemberId.min, MemberId.max, helpdesc="Switch aggregation member identifier" )
