# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from BasicCli import addShowCommandClass
from CliToken.Switch import matcherSwitchForShow
from ShowCommand import ShowCliCommandClass
from Toggles.SwagCoreToggleLib import toggleSwagPhase1Enabled

class ShowSwagSummary( ShowCliCommandClass ):
   syntax = 'show switch aggregation summary'
   cliModel = 'SwagModel.SwagSummary'
   data = {
         'switch': matcherSwitchForShow,
         'aggregation': 'aggregation',
         'summary': 'summary',
   }

   handler = 'SwagShowCliHandler.ShowSwagSummary_handler'

if toggleSwagPhase1Enabled():
   addShowCommandClass( ShowSwagSummary )
