#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliMatcher
import ShowCommand
from CliToken.Debugging import debuggingMatcherForShow

#--------------------------------------------------------------------------------
# show debugging counter { COUNTERNAME }
#--------------------------------------------------------------------------------
class DebuggingCounterCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show debugging counter { COUNTERS }'
   data = {
      'debugging' : debuggingMatcherForShow,
      'counter' : 'Print the value of a single counter',
      'COUNTERS' : CliMatcher.PatternMatcher( pattern=\
      r'[A-Za-z0-9_.:{}\[\]-]+/[A-Za-z0-9_.:{}\[\]-]+',\
      helpdesc='The full name of a counter', helpname='TABLE/COUNTER' ),
   }
   handler = "PulseCliHandler.printCounter"
   cliModel = "PulseCliModel.Match"
   privileged = True

BasicCli.addShowCommandClass( DebuggingCounterCmd )

#--------------------------------------------------------------------------------
# show debugging counters [ MATCHNAME ]
#--------------------------------------------------------------------------------
class DebuggingCountersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show debugging counters [ MATCHNAME ]'
   data = {
      'debugging' : debuggingMatcherForShow,
      'counters' : 'Print all the matching counters',
      'MATCHNAME' : CliMatcher.PatternMatcher( pattern=\
      r'[A-Za-z0-9_.:{}\[\]-]*/?[A-Za-z0-9_.:{}\[\]-]*',\
      helpdesc='The partial name of a counter to search for', helpname='NAME' ),
   }
   handler = "PulseCliHandler.printMatches"
   cliModel = "PulseCliModel.Match"
   privileged = True

BasicCli.addShowCommandClass( DebuggingCountersCmd )
