#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import LazyMount
from CliMatcher import DynamicIntegerMatcher

routingHardwareStatus = None

def maxUcmpRangeFn( mode, context ):
   # This code can be called when the startup-config is being parsed,
   # which happens before the FruAgent has discovered all the hardware
   # and populated Sysdb, allowing any value in this case and returning
   # the actual hardware supported (routingHardwareStatus.maxUcmp) in the other case
   if routingHardwareStatus and routingHardwareStatus.maxUcmp:
      return ( 1, routingHardwareStatus.maxUcmp )
   return ( 1, 0xffffffff )

ucmpSizeRange = DynamicIntegerMatcher( maxUcmpRangeFn,
                helpdesc='Value for total number UCMP nexthops' )

# -------------------------------------------------------------------------------
# Have the Cli Agent mount all needed state from sysdb
# -------------------------------------------------------------------------------
def Plugin( entityManager ):
   global routingHardwareStatus

   routingHardwareStatus = LazyMount.mount( entityManager,
         'routing/hardware/status', 'Routing::Hardware::Status', 'r' )
