#!/usr/bin/env python3
# Copyright (c) 2007, 2008, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# This module implements interface-specific VmTracer configuration.
#
# [no|default] vmtracer { vmware }
#-------------------------------------------------------------------------------
'''Interface configuration commands supported for VmTracer'''
from CliPlugin import IntfCli
import CliParser, ConfigMount, Tracing, LazyMount

bridgingHwCapabilities = None

def vmTracerSupportedGuard( mode, token ):
   if bridgingHwCapabilities.vmTracerSupported:
      return None
   return CliParser.guardNotThisPlatform

__defaultTraceHandle__ = Tracing.Handle( 'VmTracerCli' )
cdpConfig = None

#-------------------------------------------------------------------------------
# Adds VmTracer commands to the "config-if" mode.
#-------------------------------------------------------------------------------
class VmTracerModelet ( CliParser.Modelet ):
   @staticmethod
   def shouldAddModeletRule( mode ):
      # This is a bit hacky, but there's no better way to recognize physical Ethernet
      # interfaces than to look at their name.
      return ( ( mode.intf.name.startswith( 'Ethernet' ) or
                 mode.intf.name.startswith( 'Po' ) ) and
               not mode.intf.isSubIntf() )

modelet = VmTracerModelet
IntfCli.IntfConfigMode.addModelet( modelet )

#-------------------------------------------------------------------------------
# [no] vmtracer { vmware-esx }
#-------------------------------------------------------------------------------

def enableVmTracer( mode, host, no=None ):
   enableVmTracerOnIntf( mode.intf.name, no, host )

def enableVmTracerOnIntf( intfName, no, host ):
   if intfName.startswith( 'Ethernet' ):
      intfs = cdpConfig.intfNames
   else:
      intfs = cdpConfig.lagNames

   if not no:
      intfs[ intfName ] = True
   else:
      if intfName in intfs:
         del intfs[ intfName ]

class VmTracerIntf( IntfCli.IntfDependentBase ):
   def setDefault( self ):
      enableVmTracerOnIntf( self.intf_.name,
                            no=True, host='vmware-esx' )

#-------------------------------------------------------------------------------
# Have the Cli Agent mount all needed state from sysdb
#-------------------------------------------------------------------------------
def Plugin( entityManager ):
   global cdpConfig
   global bridgingHwCapabilities

   cdpConfig = ConfigMount.mount(
      entityManager, 'l2discovery/cdp/config', 'Cdp::CdpConfig', 'w' )
   IntfCli.Intf.registerDependentClass( VmTracerIntf )
   bridgingHwCapabilities = LazyMount.mount( entityManager,
                                             "bridging/hwcapabilities",
                                             "Bridging::HwCapabilities", "r" )
