#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliMatcher
# pylint: disable-next=consider-using-from-import
import CliPlugin.VmTracerIntfCli as VmTracerIntfCli

#--------------------------------------------------------------------------------
# [ no | default ] vmtracer vmware-esx
#--------------------------------------------------------------------------------
class VmtracerVmwareEsxCmd( CliCommand.CliCommandClass ):
   syntax = 'vmtracer vmware-esx'
   noOrDefaultSyntax = syntax
   data = {
      'vmtracer' : CliCommand.Node( matcher=CliMatcher.KeywordMatcher( 'vmtracer',
      helpdesc='Enable VmTracer on this interface' ),
      guard=VmTracerIntfCli.vmTracerSupportedGuard ),
      'vmware-esx' : 'Vmware-ESX host connected to this interface',
   }

   @staticmethod
   def handler( mode, args ):
      VmTracerIntfCli.enableVmTracer( mode, args.get( 'HOST' ), no=None )

   @staticmethod
   def noOrDefaultHandler ( mode, args ):
      VmTracerIntfCli.enableVmTracer( mode, args.get( 'HOST' ), no=True )

VmTracerIntfCli.VmTracerModelet.addCommandClass( VmtracerVmwareEsxCmd )
