#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliMatcher
# pylint: disable-next=consider-using-from-import
import CliPlugin.VmTracerCli as VmTracerCli

import ReversibleSecretCli

matcherUrl = CliMatcher.KeywordMatcher( 'url',
      helpdesc='URL of VMware vShield instance to connect to' )
matcherUsername = CliMatcher.KeywordMatcher( 'username',
      helpdesc='Login username for vShield instance' )

#--------------------------------------------------------------------------------
# [ no | default ] password PASSWORD 
#--------------------------------------------------------------------------------
class PasswordCmd( CliCommand.CliCommandClass ):
   syntax = 'password PASSWORD'
   noOrDefaultSyntax = 'password ...'
   data = {
      'password' : 'Login password for vShield instance',
      'PASSWORD' : ReversibleSecretCli.ReversiblePasswordCliExpression(
                     cleartextMatcher=ReversibleSecretCli.cleartextAuthMatcher,
                     obfuscatedTextMatcher=ReversibleSecretCli.type7AuthMatcher,
                     uniqueKeyGenerator=lambda mode, args: 'VShield',
                     algorithm='DES', errorMsg='Invalid encrypted password' ),
   }

   handler = VmTracerCli.VShieldConfigMode.setPassword
   noOrDefaultHandler = VmTracerCli.VShieldConfigMode.noPassword

VmTracerCli.VShieldConfigMode.addCommandClass( PasswordCmd )

#--------------------------------------------------------------------------------
# url URL
# ( no | default ) url ...
#--------------------------------------------------------------------------------
class UrlUrlCmd( CliCommand.CliCommandClass ):
   syntax = 'url URL'
   noOrDefaultSyntax = 'url ...'
   data = {
      'url' : matcherUrl,
      'URL' : CliMatcher.PatternMatcher( pattern='.+',
              helpdesc='URL of vShield', helpname='URL' ),
   }

   handler = VmTracerCli.VShieldConfigMode.setUrl
   noOrDefaultHandler = VmTracerCli.VShieldConfigMode.noUrl

VmTracerCli.VShieldConfigMode.addCommandClass( UrlUrlCmd )

#--------------------------------------------------------------------------------
# username USERNAME
# ( no | default ) username ...
#--------------------------------------------------------------------------------
class UsernameUsernameCmd( CliCommand.CliCommandClass ):
   syntax = 'username USERNAME'
   noOrDefaultSyntax = 'username ...'
   data = {
      'username' : matcherUsername,
      'USERNAME' : CliMatcher.PatternMatcher( pattern='.+',
                   helpdesc='Username to login to vShield', helpname='USERNAME' ),
   }

   handler = VmTracerCli.VShieldConfigMode.setUsername
   noOrDefaultHandler = VmTracerCli.VShieldConfigMode.noUsername

VmTracerCli.VShieldConfigMode.addCommandClass( UsernameUsernameCmd )
