#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
# pylint: disable-next=consider-using-from-import
import CliPlugin.VrfLeakCli as VrfLeakCli
import CliToken.Clear

#--------------------------------------------------------------------------------
# clear vrf leak flapping
#--------------------------------------------------------------------------------
class ClearVrfLeakFlappingCmd( CliCommand.CliCommandClass ):
   syntax = 'clear vrf leak flapping'
   data = {
      'clear': CliToken.Clear.clearKwNode,
      'vrf': 'Clear VRF state',
      'leak': 'Clear VRF leaking state',
      'flapping': 'Clear flapping prefixes',
   }

   handler = VrfLeakCli.clearFlapping

BasicCliModes.EnableMode.addCommandClass( ClearVrfLeakFlappingCmd )
