# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AgentCommandRequest
import BasicCli
import CliToken.Platform
from CliPlugin.BridgingEtbaCli import tfaNode
from CliPlugin import TechSupportCli
import ShowCommand

def showArfaVrfSelectionPolicyConfig( mode, args ):
   AgentCommandRequest.runCliPrintSocketCommand( mode.entityManager,
                                                 "Etba", "debug",
                                                 "SHOW_VRFSEL PolicyMapConfig",
                                                 mode )

platformMatcherForShow = CliToken.Platform.platformMatcherForShow

class ShowArfaShowVrfSelectionPolicyConfigCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show platform tfa vrf selection policy config'
   data = {
      'platform': platformMatcherForShow,
      'tfa': tfaNode,
      'vrf': 'VRF selection policy',
      'selection': 'VRF selection policy',
      'policy': 'VRF selection policy',
      'config': 'VRF selection policy internal config for TFA',
   }

   handler = showArfaVrfSelectionPolicyConfig
   hidden = True

BasicCli.addShowCommandClass( ShowArfaShowVrfSelectionPolicyConfigCmd )

def showArfaVrfSelectionPolicyStatus( mode, args ):
   AgentCommandRequest.runCliPrintSocketCommand( mode.entityManager,
                                                 "Etba", "debug",
                                                 "SHOW_VRFSEL PolicyMapStatus",
                                                 mode )

class ShowArfaShowVrfSelectionPolicyStatusCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show platform tfa vrf selection policy status'
   data = {
      'platform': platformMatcherForShow,
      'tfa': tfaNode,
      'vrf': 'VRF selection policy',
      'selection': 'VRF selection policy',
      'policy': 'VRF selection policy',
      'status': 'VRF selection policy internal status for TFA',
   }

   handler = showArfaVrfSelectionPolicyStatus
   hidden = True

BasicCli.addShowCommandClass( ShowArfaShowVrfSelectionPolicyStatusCmd )

# Add all of these commands to "show tech-support extended tfa"
TechSupportCli.registerShowTechSupportCmd(
      '2023-01-17 13:41:56', cmds=[
         "show platform tfa vrf selection policy config",
         "show platform tfa vrf selection policy status",
         ],
      extended="tfa" )
