# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin.TrafficPolicyCliModel import TrafficPolicy
from CliModel import Dict, Enum, DeferredModel
from TypeFuture import TacLazyType

DecapVrfState = TacLazyType( "VrfSelectionPolicy::DecapVrfState" )

class VrfSelectionPolicyModel( DeferredModel ):
   nexthopFeature = Enum( values=DecapVrfState.attributes,
                          help="Next-hop feature status", optional=True )
   vrfSelectionPolicies = Dict( valueType=TrafficPolicy,
                          help="VRF selection policy indexed by policy name",
                          optional=True )
