# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import TechSupportCli
import LazyMount

# -------------------------------------------------------------------------------
# Vrf Selection Policy commands in 'show tech-support'
# -------------------------------------------------------------------------------
vrfSelPolicyHwCapabilities = None

def _vrfSelectionPolicyShowTechGuard():
   return ( vrfSelPolicyHwCapabilities and
            vrfSelPolicyHwCapabilities.vrfSelectionSupported )

TechSupportCli.registerShowTechSupportCmd(
      '2024-04-10 11:37:07',
      cmds=[ 'show vrf selection policy' ],
      cmdsGuard=_vrfSelectionPolicyShowTechGuard )

def Plugin( entityManager ):
   global vrfSelPolicyHwCapabilities
   vrfSelPolicyHwCapabilities = LazyMount.mount( entityManager,
                                          'vrfSelectionPolicy/hwcapabilities',
                                          'VrfSelectionPolicy::HwCapabilities',
                                          'r' )
