# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Arnet
import ConfigMount

vxlanCntrlConfig = None

def vtepListToMultiRangeString( vlanToVtepList ):
   ''' This function accepts a collection of vlan to VtepList mappings and
   returns a list of tuples. Where the tuple contains a list of vteps and a
   multi-range string. Note that the IP addresses in the vtep list are
   sorted and the multi-range strings are ordered by the lowest vlan in the
   range.
   
   For example the following vlan to vtep list:
   { 10 : [ 10.0.0.1, 10.0.0.2, 10.0.0.3],
     11 : [ 10.0.0.1, 10.0.0.2, 10.0.0.3],
     12 : [ 10.0.0.1, 10.0.0.2, 10.0.0.3] }

   Would be transformed to:
   [ ( 10.0.0.1, 10.0.0.2, 10.0.0.3 ),  '10-12' ]
   '''

   ll = []
   if vlanToVtepList:
      dd = {}
      for ( vlan, vl ) in vlanToVtepList.items():
         if hasattr( vl, 'remoteVtepAddr' ):
            vl = vl.remoteVtepAddr
         if hasattr( vl, 'vteps' ):
            vl = vl.vteps
         key = tuple( sorted( vl, key = lambda x: Arnet.IpAddress( x ).value ) )
         if not key in dd: # pylint: disable=unneeded-not
            mrs = Tac.newInstance( 'EbraUtils::VlanIdSet' )
            mrs.doAdd( vlan )
            dd[ key ] = mrs
         else:
            dd[ key ].doAdd( vlan )

      # pylint: disable-next=unnecessary-comprehension
      ll = [ ( key, value ) for ( key, value ) in
             sorted( dd.items(),
                   key = lambda __x : __x[ 1 ].multiRangeString() ) ]
   return ll 

def Plugin( entityManager ):
   global vxlanCntrlConfig
   vxlanCntrlConfig = ConfigMount.mount( entityManager,
                                     "vxlancontroller/config",
                                     "VxlanController::Config", "w" )
