# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import LazyMount

def xcvrAllStatusDir( em ):
   return XcvrAllStatusProxy( em )

class XcvrAllStatusProxy:
   def __init__( self, em ):
      self.fixedStatusDir_ = LazyMount.mount( em,
         'hardware/archer/xcvr/status/all', 'Tac::Dir', 'ri' )
      self.sliceStatusDir_ = LazyMount.mount( em,
         'hardware/archer/xcvr/status/slice', 'Tac::Dir', 'ri' )
      self.fixedConfigDir_ = None
      self.baseConfigDir_ = LazyMount.mount( em,
         'hardware/xcvr/config', 'Tac::Dir', 'ri' )
      self.fixedAgentStatus_ = LazyMount.mount( em,
         'hardware/archer/xcvr/agent/status/fixed', 'Xcvr::XcvrSliceStatus', 'r' )
      self.agentStatusDir_ = LazyMount.mount( em,
         'hardware/archer/xcvr/agent/status/slice', 'Tac::Dir', 'ri' )
      self.asd_ = None

   def __getXcvrStatus( self ):
      if not self.asd_:
         asdSingleton = Tac.singleton( "Xcvr::XcvrAllStatusDirSingleton" )
         asdSingleton.fixedStatusDir = LazyMount.force( self.fixedStatusDir_ )
         asdSingleton.sliceStatusDir = LazyMount.force( self.sliceStatusDir_ )
         asdSingleton.baseConfigDir = LazyMount.force( self.baseConfigDir_ )
         asdSingleton.fixedConfigDir = asdSingleton.baseConfigDir[ 'all' ]
         asdSingleton.fixedAgentStatus = LazyMount.force( self.fixedAgentStatus_ )
         asdSingleton.agentStatusDir = LazyMount.force( self.agentStatusDir_ )

         asdSingleton.doStartSm()
         self.asd_ = asdSingleton.allStatusDir
      return self.asd_

   def __getitem__( self, key ):
      return self.__getXcvrStatus().__getitem__( key )

   def __getattr__( self, attr ):
      return getattr( self.__getXcvrStatus(), attr )

   def force( self ):
      return self.__getXcvrStatus()
