# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ShowCommand
import Intf
import BasicCli
import Tac
from CliPlugin.EthIntfCli import xcvrShowKw
import IntfRangePlugin.XcvrSlot

# -----------------------------------------------------------------------------------
#
# show transceiver cdb capabilities slot <SLOTIF>
#
# Note that "slot <SLOTID>" uses a single matcher that matches two tokens.
# -----------------------------------------------------------------------------------

xcvrCdbShowSlotType = IntfRangePlugin.XcvrSlot.XcvrSlot(
   "slot", "Transceiver slot to have its capabilities displayed" )
slotRangeShowMatcher = Intf.IntfRange.IntfRangeMatcher(
   explicitIntfTypes=( xcvrCdbShowSlotType, ),
   dollarCompHelpText="Slot list end" )

class ShowXcvrCdbCapabilities( ShowCommand.ShowCliCommandClass ):
   syntax = 'show transceiver cdb capabilities [ SLOTS ]'
   data = {
      'transceiver': xcvrShowKw,
      'cdb': 'Show information about CMIS transceiver CDB features',
      'capabilities': 'Show advertised CMIS CDB capabilities',
      'SLOTS': slotRangeShowMatcher
   }
   handler = "XcvrCmisCdbCliHandler.handleShowXcvrCdbCapabilities"
   cliModel = "XcvrCdbCapabilitiesModel.TransceiverCdbCapabilitiesSlotCollection"

BasicCli.addShowCommandClass( ShowXcvrCdbCapabilities )
