# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
from Toggles import XcvrToggleLib
from CliPlugin.XcvrConfigCli import ( Layer1MonitorMode, matcherLogging,
                                      matcherLoggingTransceiver )

# --------------------------------------------------------------------------------
# [ no | default ] logging transceiver dom
# --------------------------------------------------------------------------------

class LoggingTransceiverDomCmd( CliCommand.CliCommandClass ):
   syntax = 'logging transceiver dom'
   noOrDefaultSyntax = syntax
   data = {
         'logging': matcherLogging,
         'transceiver': matcherLoggingTransceiver,
         'dom': 'Enable transceiver digital optical monitoring (DOM) logging',
   }

   handler = "XcvrLoggingHandlerDom.LoggingTransceiverDomCmdHandler"
   noOrDefaultHandler = "XcvrLoggingHandlerDom.LoggingTransceiverDomCmdNoHandler"

if XcvrToggleLib.toggleSmbusErrLogsEnabled():
   Layer1MonitorMode.addCommandClass( LoggingTransceiverDomCmd )
