# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
from Toggles import XcvrToggleLib
from CliPlugin.XcvrConfigCli import ( Layer1MonitorMode, matcherLogging,
                                      matcherLoggingTransceiver )

# --------------------------------------------------------------------------------
# [ no | default ] logging transceiver communication
# --------------------------------------------------------------------------------

class LoggingTransceiverCommunicationCmd( CliCommand.CliCommandClass ):
   syntax = 'logging transceiver communication'
   noOrDefaultSyntax = syntax
   data = {
         'logging': matcherLogging,
         'transceiver': matcherLoggingTransceiver,
         'communication': 'Enable transceiver SMBus fail and reset logging',
   }

   handler = ( "XcvrLoggingHandlerCommunication."
      "LoggingTransceiverCommunicationCmdHandler" )

   noOrDefaultHandler = ( "XcvrLoggingHandlerCommunication."
      "LoggingTransceiverCommunicationCmdNoHandler" )

if XcvrToggleLib.toggleSmbusErrLogsEnabled():
   Layer1MonitorMode.addCommandClass( LoggingTransceiverCommunicationCmd )
