#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import LazyMount
import Tac

intfXcvrStatusDir = None

class EthIntfXcvrStatusDirProxy:
   def __init__( self, em ):
      self.remoteDir_ = LazyMount.mount( em,
         'interface/archer/eth/xcvr/slice', 'Tac::Dir', 'ri' )
      self.invDirRoot_ = LazyMount.mount( em,
         'hardware/xcvrController/config', 'Tac::Dir', 'ri' )
      self.intfXcvrStatusDirHelperCreator_ = None
      self.localDir_ = None
      self.dummyEthernet_ = Tac.newInstance( 'Interface::EthIntfXcvrStatus', '' )

   def __getEthIntfXcvrStatus( self ):
      if not self.localDir_:
         invDirRoot = LazyMount.force( self.invDirRoot_ )
         self.intfXcvrStatusDirHelperCreator_ = Tac.newInstance(
            "Xcvr::EthIntfXcvrStatusDirHelperCreator", "all",
            LazyMount.force( self.remoteDir_ ),
            invDirRoot.entity.get( 'slice' ) )
         self.intfXcvrStatusDirHelperCreator_.doStartOperations()
         self.localDir_ = self.intfXcvrStatusDirHelperCreator_.localDir
      return self.localDir_.intfXcvrStatus

   def get( self, key ):
      intfXcvrStatus = self.__getEthIntfXcvrStatus().get( key )
      # When the intf does not present in the EthIntfXcvrStatus collection,
      # it usually means that the XcvrAgent is not ready. We should return
      # an EthIntfXcvrStatus with default values.
      if not intfXcvrStatus:
         intfXcvrStatus = self.dummyEthernet_
      return intfXcvrStatus

def ethIntfXcvrStatusDir( em=None ):
   global intfXcvrStatusDir
   if not intfXcvrStatusDir:
      assert em
      intfXcvrStatusDir = EthIntfXcvrStatusDirProxy( em )
   return intfXcvrStatusDir

