# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin.EthIntfCli import xcvrKw, xcvrShowKw
import BasicCli
import CliCommand
import ShowCommand

class ShowTuningExceptionStatus( ShowCommand.ShowCliCommandClass ):
   syntax = 'show transceiver status electrical tuning file'
   data = {
      'transceiver': xcvrShowKw,
      'status': 'Show transceiver status information',
      'electrical': 'Show transceiver electrical side state',
      'tuning': 'Show tuning state',
      'file': 'Show tuning file status'
   }
   handler = "XcvrTuningExceptionHandler.showTransceiverElectricalTuningFileHandler"
   cliModel = "XcvrTuningExceptionModel.TransceiverShowTuningExceptionModel"

class TransceiverTuningFileReload( CliCommand.CliCommandClass ):
   syntax = 'transceiver electrical tuning file reload'
   data = {
      'transceiver': xcvrKw,
      'electrical': 'Manage transceiver electrical side parameters',
      'tuning': 'Manage transceiver tuning',
      'file': 'Apply transceiver tuning values from file',
      'reload': 'Apply transceiver tuning values from modified file',
   }
   handler = "XcvrTuningExceptionHandler.transceiverTuningExceptionReloadHandler"

BasicCli.addShowCommandClass( ShowTuningExceptionStatus )
BasicCli.EnableMode.addCommandClass( TransceiverTuningFileReload )
