# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliPlugin.IntfCli as IntfCli # pylint: disable=consider-using-from-import
import CliPlugin.DmfCli as DmfCli # pylint: disable=consider-using-from-import
import ConfigMount
import Tac
from TypeFuture import TacLazyType

ztnConfig = None
HashAlg = TacLazyType( "Ztn::HashAlgorithm" )

#-------------------------------------------------------------------------------
# [no|default] source-interface INTF
#-------------------------------------------------------------------------------
class SourceInterfaceCmd( CliCommand.CliCommandClass ):
   syntax = 'source-interface INTF'
   noOrDefaultSyntax = 'source-interface ...'
   data = {
      'source-interface': 'Interface used to connect to DMF controller',
      'INTF': IntfCli.Intf.matcherWithIpSupport,
   }
   # This command is used only for testing to override the default 'ma1' intf
   hidden = True

   @staticmethod
   def handler( mode, args ):
      intf = args[ 'INTF' ]
      ztnConfig.sourceIntf = intf.name

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      ztnConfig.sourceIntf = ''

DmfCli.DmfConfigMode.addCommandClass( SourceInterfaceCmd )

#-------------------------------------------------------------------------------
# [no|default] handshake disabled
#-------------------------------------------------------------------------------
class HandshakeBypassCmd( CliCommand.CliCommandClass ):
   syntax = 'handshake disabled'
   noOrDefaultSyntax = syntax
   data = {
      'handshake': 'ZTN handshake',
      'disabled': 'Skip doing the operation'
   }
   hidden = True

   @staticmethod
   def handler( mode, args ):
      ztnConfig.bypassHandshake = True

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      ztnConfig.bypassHandshake = False

DmfCli.DmfConfigMode.addCommandClass( HandshakeBypassCmd )

#-------------------------------------------------------------------------------
# [no|default] handshake reload disabled
#-------------------------------------------------------------------------------
class ReloadBypassCmd( CliCommand.CliCommandClass ):
   syntax = 'handshake reload disabled'
   noOrDefaultSyntax = syntax
   data = {
      'handshake': 'ZTN handshake',
      'reload': 'Reload after installing new image',
      'disabled': 'Skip doing the operation'
   }
   hidden = True

   @staticmethod
   def handler( mode, args ):
      ztnConfig.skipReboot = True

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      ztnConfig.skipReboot = False

DmfCli.DmfConfigMode.addCommandClass( ReloadBypassCmd )


def Plugin( em ):
   global ztnConfig
   ztnConfig = ConfigMount.mount( em, 'ztn/config', 'Ztn::Config', 'w' )
