# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliMatcher
# pylint: disable-next=consider-using-from-import
import CliPlugin.ConfigMgmtMode as ConfigMgmtMode
import CliPlugin.DmfCli as DmfCli # pylint: disable=consider-using-from-import
import CliPlugin.ZtnModel as ZtnModel # pylint: disable=consider-using-from-import
import LazyMount
import ShowCommand
import Tac
from TypeFuture import TacLazyType

dmfConfig = None
ztnStatus = None
HashAlgo = TacLazyType( 'Ztn::HashAlgorithm' )

ztMatcher = CliMatcher.KeywordMatcher( 'zerotouch',
      helpdesc='Display Zero Touch Networking information' )

#---------------------------------------------------
# show management dmf controller zerotouch
#---------------------------------------------------
class ZtnShowCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show management dmf controller zerotouch'
   data = {
      'management': ConfigMgmtMode.managementShowKwMatcher,
      'dmf': DmfCli.dmfMatcher,
      'controller': DmfCli.dmfCtrlrMatcher,
      'zerotouch': ztMatcher,
   }
   cliModel = ZtnModel.ZtnStatus

   @staticmethod
   def handler( mode, args ):
      model = ZtnModel.ZtnStatus()
      model.enabled = ztnStatus.enabled
      model.controllers = list( dmfConfig.controller )
      model.manifestTimestamp = ztnStatus.manifestTs
      model.state = ztnStatus.syncState
      if ztnStatus.syncState != 'complete':
         model.errorMessage = ztnStatus.lastKnownError
      return model

BasicCli.addShowCommandClass( ZtnShowCmd )

#---------------------------------------------------
# show management dmf controller zerotouch detail
#---------------------------------------------------
class ZtnShowDetail( ShowCommand.ShowCliCommandClass ):
   syntax = 'show management dmf controller zerotouch detail'
   data = {
      'management': ConfigMgmtMode.managementShowKwMatcher,
      'dmf': DmfCli.dmfMatcher,
      'controller': DmfCli.dmfCtrlrMatcher,
      'zerotouch': ztMatcher,
      'detail': 'Display information in detail',
   }
   cliModel = ZtnModel.ZtnStatusDetail

   @staticmethod
   def handler( mode, args ):
      model = ZtnModel.ZtnStatusDetail()
      model.enabled = ztnStatus.enabled
      model.platform = ztnStatus.platform
      model.systemMac = ztnStatus.systemMac
      model.configUrl = ztnStatus.configUrl
      model.configDigest = ztnStatus.manifestConfigChecksum.get(
                              HashAlgo.sha256, '' )
      model.imageUrl = ztnStatus.swiUrl
      model.imageDigest = ztnStatus.swiManifestChecksum
      for entry in reversed( list( ztnStatus.log.values() ) ):
         log = ZtnModel.LogMsg( timestamp=entry.ts, message=entry.msg )
         model.logMessages.append( log )
      return model

BasicCli.addShowCommandClass( ZtnShowDetail )

#---------------------------------------------------
# show management dmf version
#---------------------------------------------------
def showDigest( mode, args ):
   digest = None
   if ztnStatus.swiManifestChecksum:
      digest = ZtnModel.Digest()
      digest.sha256 = ztnStatus.swiManifestChecksum
   else:
      mode.addError( 'Digest of the image is unavailable' )
   return digest

class ShowVersionDigestCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show management dmf version'
   data = {
      'management': ConfigMgmtMode.managementShowKwMatcher,
      'dmf': DmfCli.dmfMatcher,
      'version': 'Show digest of the image',
   }
   cliModel = ZtnModel.Digest
   handler = showDigest

BasicCli.addShowCommandClass( ShowVersionDigestCmd )

def Plugin( em ):
   global dmfConfig
   global ztnStatus
   dmfConfig = LazyMount.mount( em, 'dmf/cli/config', 'Dmf::Cli::Config', 'r' )
   ztnStatus = LazyMount.mount( em, 'ztn/status', 'Ztn::Status', 'r' )
