# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
from CliSavePlugin.AclCliSave import IpAclConfigMode
from CliSavePlugin.IntfCliSave import IntfConfigMode
from CliSavePlugin.EbraCliSave import VlanConfigMode
import Vlan
import CliSave
import re

CliSave.GlobalConfigMode.addCommandSequence( "Aegis.intf",
                                             after=[ IpAclConfigMode ] )
IntfConfigMode.addCommandSequence( "Aegis.intf" )

CliSave.GlobalConfigMode.addCommandSequence( "Aegis.intfEgress",
                                             after=[ IpAclConfigMode ] )
IntfConfigMode.addCommandSequence( "Aegis.intfEgress" )

CliSave.GlobalConfigMode.addCommandSequence( "Aegis.intfBridged",
                                             after=[ IpAclConfigMode ] )
VlanConfigMode.addCommandSequence( "Aegis.intfBridged" )

@CliSave.saver( "PolicyMap::IntfConfig", "trafficPolicies/intf/input/aegis",
      requireMounts=( "trafficPolicies/hardware/status/interface", ) )
def saveAegisIntfConfigIngress( entity, root, requireMounts, options ):
   if entity is None:
      return
   hwStatus = requireMounts[ 'trafficPolicies/hardware/status/interface' ]
   for intf, policyName in entity.intf.items():
      mode = root[ IntfConfigMode ].getOrCreateModeInstance( intf )
      cmds = mode[ "Aegis.intf" ]
      cmd = f'traffic-policy input {policyName}'
      if hwStatus.intfAppAlwaysOverride:
         cmd += ' fallback traffic-policy none'
      cmds.addCommand( cmd )

@CliSave.saver( "PolicyMap::IntfConfig", "trafficPolicies/intf/output/aegis" )
def saveAegisIntfConfigEgress( entity, root, requireMounts, options ):
   if entity is None:
      return
   for intf, policyName in entity.intf.items():
      mode = root[ IntfConfigMode ].getOrCreateModeInstance( intf )
      cmds = mode[ "Aegis.intfEgress" ]
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( "traffic-policy output %s" % policyName )

@CliSave.saver( "PolicyMap::IntfConfig", "trafficPolicies/intf/bridged/aegis" )
def saveAegisIntfConfigBridged( entity, root, requiredMounts, options ):
   if entity is None:
      return
   for intf, policyName in entity.intf.items():
      # translate intfId('Vlan#') to vlanId('#')
      pattern = re.compile( r'\d+' )
      vlanId = int( pattern.search( intf ).group( 0 ) )
      vlanString = Vlan.vlanSetToCanonicalString( [ vlanId ] )
      mode = root[ VlanConfigMode ].getOrCreateModeInstance( ( vlanId,
                                                               vlanString,
                                                               True ) )
      cmds = mode[ "Aegis.intfBridged" ]
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( "traffic-policy %s" % policyName )
